/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComplementPackageSet
extends PackageSetBase {
    private final PackageSet myComplementarySet;

    public ComplementPackageSet(PackageSet set) {
        this.myComplementarySet = set;
    }

    @Override
    public boolean contains(VirtualFile file, @NotNull NamedScopesHolder holder) {
        return this.contains(file, holder.getProject(), holder);
    }

    @Override
    public boolean contains(VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
        return this.myComplementarySet instanceof PackageSetBase ? !((PackageSetBase)this.myComplementarySet).contains(file, project, holder) : this.myComplementarySet.contains(ComplementPackageSet.getPsiFile(file, project), holder);
    }

    @Override
    @NotNull
    public PackageSet createCopy() {
        return new ComplementPackageSet(this.myComplementarySet.createCopy());
    }

    @Override
    @NotNull
    public String getText() {
        StringBuffer buf = new StringBuffer();
        boolean needParen = this.myComplementarySet.getNodePriority() > this.getNodePriority();
        buf.append('!');
        if (needParen) {
            buf.append('(');
        }
        buf.append(this.myComplementarySet.getText());
        if (needParen) {
            buf.append(')');
        }
        return buf.toString();
    }

    @Override
    public int getNodePriority() {
        return 1;
    }

    public PackageSet getComplementarySet() {
        return this.myComplementarySet;
    }
}

