/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.TodoAttributes;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TodoPattern
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.search.TodoPattern");
    private IndexPattern myIndexPattern;
    private TodoAttributes myAttributes;
    @NonNls
    private static final String CASE_SENS_ATT = "case-sensitive";
    @NonNls
    private static final String PATTERN_ATT = "pattern";

    public TodoPattern(@NotNull TodoAttributes attributes) {
        this("", attributes, false);
    }

    public TodoPattern(@NotNull @NonNls String patternString, @NotNull TodoAttributes attributes, boolean caseSensitive) {
        this.myIndexPattern = new IndexPattern(patternString, caseSensitive);
        this.myAttributes = attributes;
    }

    public TodoPattern clone() {
        try {
            TodoAttributes attributes = this.myAttributes.clone();
            TodoPattern pattern = (TodoPattern)super.clone();
            pattern.myIndexPattern = new IndexPattern(this.myIndexPattern.getPatternString(), this.myIndexPattern.isCaseSensitive());
            pattern.myAttributes = attributes;
            return pattern;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public String getPatternString() {
        return this.myIndexPattern.getPatternString();
    }

    public void setPatternString(@NotNull String patternString) {
        this.myIndexPattern.setPatternString(patternString);
    }

    @NotNull
    public TodoAttributes getAttributes() {
        return this.myAttributes;
    }

    public void setAttributes(@NotNull TodoAttributes attributes) {
        this.myAttributes = attributes;
    }

    public boolean isCaseSensitive() {
        return this.myIndexPattern.isCaseSensitive();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.myIndexPattern.setCaseSensitive(caseSensitive);
    }

    public Pattern getPattern() {
        return this.myIndexPattern.getPattern();
    }

    public void readExternal(Element element, @NotNull TextAttributes defaultTodoAttributes) {
        try {
            this.myAttributes = new TodoAttributes(element, defaultTodoAttributes);
        }
        catch (InvalidDataException e) {
            throw new RuntimeException(e);
        }
        this.myIndexPattern.setCaseSensitive(Boolean.valueOf(element.getAttributeValue(CASE_SENS_ATT)));
        String attributeValue = element.getAttributeValue(PATTERN_ATT);
        if (attributeValue != null) {
            this.myIndexPattern.setPatternString(attributeValue.trim());
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myAttributes.writeExternal(element);
        element.setAttribute(CASE_SENS_ATT, Boolean.toString(this.myIndexPattern.isCaseSensitive()));
        element.setAttribute(PATTERN_ATT, this.myIndexPattern.getPatternString());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TodoPattern)) {
            return false;
        }
        TodoPattern pattern = (TodoPattern)obj;
        if (!this.myIndexPattern.equals(pattern.myIndexPattern)) {
            return false;
        }
        return Comparing.equal((Object)this.myAttributes, (Object)pattern.myAttributes);
    }

    public int hashCode() {
        return this.myIndexPattern.hashCode();
    }

    public IndexPattern getIndexPattern() {
        return this.myIndexPattern;
    }
}

