/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScopeBuilder;
import org.jetbrains.annotations.NotNull;

public class ProjectScope {
    private static final Key<GlobalSearchScope> ALL_SCOPE_KEY = new Key("ALL_SCOPE_KEY");
    private static final Key<GlobalSearchScope> PROJECT_SCOPE_KEY = new Key("PROJECT_SCOPE_KEY");
    private static final Key<GlobalSearchScope> LIBRARIES_SCOPE_KEY = new Key("LIBRARIES_SCOPE_KEY");
    private static final Key<GlobalSearchScope> CONTENT_SCOPE_KEY = new Key("CONTENT_SCOPE_KEY");

    private ProjectScope() {
    }

    @NotNull
    public static GlobalSearchScope getAllScope(@NotNull Project project) {
        GlobalSearchScope cached = (GlobalSearchScope)project.getUserData(ALL_SCOPE_KEY);
        return cached != null ? cached : (GlobalSearchScope)((UserDataHolderEx)project).putUserDataIfAbsent(ALL_SCOPE_KEY, (Object)ProjectScopeBuilder.getInstance(project).buildAllScope());
    }

    @NotNull
    public static GlobalSearchScope getProjectScope(@NotNull Project project) {
        GlobalSearchScope cached = (GlobalSearchScope)project.getUserData(PROJECT_SCOPE_KEY);
        return cached != null ? cached : (GlobalSearchScope)((UserDataHolderEx)project).putUserDataIfAbsent(PROJECT_SCOPE_KEY, (Object)ProjectScopeBuilder.getInstance(project).buildProjectScope());
    }

    @NotNull
    public static GlobalSearchScope getLibrariesScope(@NotNull Project project) {
        GlobalSearchScope cached = (GlobalSearchScope)project.getUserData(LIBRARIES_SCOPE_KEY);
        return cached != null ? cached : (GlobalSearchScope)((UserDataHolderEx)project).putUserDataIfAbsent(LIBRARIES_SCOPE_KEY, (Object)ProjectScopeBuilder.getInstance(project).buildLibrariesScope());
    }

    @NotNull
    public static GlobalSearchScope getContentScope(@NotNull Project project) {
        GlobalSearchScope cached = (GlobalSearchScope)project.getUserData(CONTENT_SCOPE_KEY);
        return cached != null ? cached : (GlobalSearchScope)((UserDataHolderEx)project).putUserDataIfAbsent(CONTENT_SCOPE_KEY, (Object)ProjectScopeBuilder.getInstance(project).buildContentScope());
    }
}

