/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NonClasspathDirectoriesScope
extends GlobalSearchScope {
    private final Set<VirtualFile> myRoots;

    public NonClasspathDirectoriesScope(@NotNull Collection<VirtualFile> roots) {
        this.myRoots = ContainerUtil.newHashSet(roots);
    }

    @Override
    public boolean isSearchOutsideRootModel() {
        return true;
    }

    @NotNull
    public static GlobalSearchScope compose(@NotNull List<VirtualFile> roots) {
        if (roots.isEmpty()) {
            return EMPTY_SCOPE;
        }
        return new NonClasspathDirectoriesScope(roots);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        return VfsUtilCore.isUnder(file, this.myRoots);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        return 0;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return false;
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NonClasspathDirectoriesScope)) {
            return false;
        }
        NonClasspathDirectoriesScope that = (NonClasspathDirectoriesScope)o;
        return this.myRoots.equals(that.myRoots);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myRoots.hashCode();
        return result;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if (this.myRoots.size() == 1) {
            VirtualFile root = this.myRoots.iterator().next();
            return "Directory '" + root.getName() + "'";
        }
        return "Directories " + StringUtil.join(this.myRoots, (Function)new Function<VirtualFile, String>(){

            public String fun(VirtualFile file) {
                return "'" + file.getName() + "'";
            }
        }, (String)", ");
    }
}

