/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class GlobalSearchScopes
extends GlobalSearchScopesCore {
    public static final String OPEN_FILES_SCOPE_NAME = "Open Files";

    private GlobalSearchScopes() {
    }

    @NotNull
    public static GlobalSearchScope openFilesScope(@NotNull Project project) {
        Object[] files = FileEditorManager.getInstance(project).getOpenFiles();
        if (ArrayUtil.isEmpty((Object[])files)) {
            return GlobalSearchScope.fileScope(project, null, OPEN_FILES_SCOPE_NAME);
        }
        return GlobalSearchScope.filesScope(project, Arrays.asList(files), OPEN_FILES_SCOPE_NAME);
    }
}

