/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class DelegatingGlobalSearchScope
extends GlobalSearchScope {
    protected final GlobalSearchScope myBaseScope;
    private final Object myEquality;

    public DelegatingGlobalSearchScope(@NotNull GlobalSearchScope baseScope) {
        this(baseScope, ArrayUtil.EMPTY_OBJECT_ARRAY);
    }

    public DelegatingGlobalSearchScope(@NotNull GlobalSearchScope baseScope, Object ... equality) {
        super(baseScope.getProject());
        this.myBaseScope = baseScope;
        this.myEquality = Arrays.asList(equality);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        return this.myBaseScope.contains(file);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        return this.myBaseScope.compare(file1, file2);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return this.myBaseScope.isSearchInModuleContent(aModule);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        return this.myBaseScope.isSearchInModuleContent(aModule, testSources);
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.myBaseScope.isSearchInLibraries();
    }

    @Override
    public boolean isSearchOutsideRootModel() {
        return this.myBaseScope.isSearchOutsideRootModel();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.myBaseScope.getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegatingGlobalSearchScope that = (DelegatingGlobalSearchScope)o;
        if (!this.myBaseScope.equals(that.myBaseScope)) {
            return false;
        }
        return this.myEquality.equals(that.myEquality);
    }

    @Override
    public int hashCode() {
        int result = this.myBaseScope.hashCode();
        result = 31 * result + this.myEquality.hashCode();
        return result;
    }
}

