/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.injection;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Injectable
implements Comparable<Injectable> {
    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getDisplayName();

    @Nullable
    public String getAdditionalDescription() {
        return null;
    }

    @NotNull
    public Icon getIcon() {
        return EmptyIcon.ICON_16;
    }

    @Override
    public int compareTo(@NotNull Injectable o) {
        return this.getDisplayName().compareTo(o.getDisplayName());
    }

    @Nullable
    public abstract Language getLanguage();

    public Language toLanguage() {
        return this.getLanguage() == null ? new Language(this.getId(), false){

            @Override
            @NotNull
            public String getDisplayName() {
                return Injectable.this.getDisplayName();
            }
        } : this.getLanguage();
    }

    public static Injectable fromLanguage(final Language language) {
        return new Injectable(){

            @Override
            @NotNull
            public String getId() {
                return language.getID();
            }

            @Override
            @NotNull
            public String getDisplayName() {
                return language.getDisplayName();
            }

            @Override
            @Nullable
            public String getAdditionalDescription() {
                LanguageFileType ft = language.getAssociatedFileType();
                return ft != null ? " (" + ft.getDescription() + ")" : null;
            }

            @Override
            @NotNull
            public Icon getIcon() {
                LanguageFileType ft = language.getAssociatedFileType();
                return ft != null && ft.getIcon() != null ? ft.getIcon() : EmptyIcon.ICON_16;
            }

            @Override
            public Language getLanguage() {
                return language;
            }
        };
    }
}

