/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CompositeArrangementEntryMatcher
implements ArrangementEntryMatcher {
    @NotNull
    private final Set<ArrangementEntryMatcher> myMatchers = new HashSet<ArrangementEntryMatcher>();

    public CompositeArrangementEntryMatcher(ArrangementEntryMatcher ... matchers) {
        this.myMatchers.addAll(Arrays.asList(matchers));
    }

    @Override
    public boolean isMatched(@NotNull ArrangementEntry entry) {
        for (ArrangementEntryMatcher matcher : this.myMatchers) {
            if (matcher.isMatched(entry)) continue;
            return false;
        }
        return true;
    }

    public void addMatcher(@NotNull ArrangementEntryMatcher rule) {
        this.myMatchers.add(rule);
    }

    public int hashCode() {
        return this.myMatchers.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeArrangementEntryMatcher matcher = (CompositeArrangementEntryMatcher)o;
        return this.myMatchers.equals(matcher.myMatchers);
    }

    public String toString() {
        return String.format("all of those: %s", this.myMatchers);
    }
}

