/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import org.jetbrains.annotations.NotNull;

public class ArrangementMatchRule {
    @NotNull
    public static final ArrangementSettingsToken DEFAULT_ORDER_TYPE = StdArrangementTokens.Order.KEEP;
    @NotNull
    private final ArrangementEntryMatcher myMatcher;
    @NotNull
    private final ArrangementSettingsToken myOrderType;

    public ArrangementMatchRule(@NotNull ArrangementEntryMatcher matcher) {
        this(matcher, DEFAULT_ORDER_TYPE);
    }

    public ArrangementMatchRule(@NotNull ArrangementEntryMatcher matcher, @NotNull ArrangementSettingsToken orderType) {
        this.myMatcher = matcher;
        this.myOrderType = orderType;
    }

    @NotNull
    public ArrangementEntryMatcher getMatcher() {
        return this.myMatcher;
    }

    @NotNull
    public ArrangementSettingsToken getOrderType() {
        return this.myOrderType;
    }

    public int hashCode() {
        int result = this.myMatcher.hashCode();
        result = 31 * result + this.myOrderType.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrangementMatchRule that = (ArrangementMatchRule)o;
        return this.myOrderType == that.myOrderType && this.myMatcher.equals(that.myMatcher);
    }

    public String toString() {
        return String.format("matcher: %s, sort type: %s", this.myMatcher, this.myOrderType);
    }
}

