/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.WalkingState;
import org.jetbrains.annotations.NotNull;

public abstract class PsiWalkingState
extends WalkingState<PsiElement> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.PsiWalkingState");
    private final PsiElementVisitor myVisitor;

    protected PsiWalkingState(@NotNull PsiElementVisitor delegate) {
        this(delegate, PsiTreeGuide.instance);
    }

    protected PsiWalkingState(@NotNull PsiElementVisitor delegate, @NotNull WalkingState.TreeGuide<PsiElement> guide) {
        super(guide);
        this.myVisitor = delegate;
    }

    public void visit(@NotNull PsiElement element) {
        element.accept(this.myVisitor);
    }

    public void elementStarted(@NotNull PsiElement element) {
        if (!this.startedWalking && element instanceof PsiCompiledElement) {
            LOG.error(element + "; Do not use walking visitor inside compiled PSI since getNextSibling() is too slow there");
        }
        super.elementStarted((Object)element);
    }

    private static class PsiTreeGuide
    implements WalkingState.TreeGuide<PsiElement> {
        private static final PsiTreeGuide instance = new PsiTreeGuide();

        private PsiTreeGuide() {
        }

        public PsiElement getNextSibling(@NotNull PsiElement element) {
            return element.getNextSibling();
        }

        public PsiElement getPrevSibling(@NotNull PsiElement element) {
            return element.getPrevSibling();
        }

        public PsiElement getFirstChild(@NotNull PsiElement element) {
            return element.getFirstChild();
        }

        public PsiElement getParent(@NotNull PsiElement element) {
            return element.getParent();
        }
    }
}

