/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiElementFinder {
    public static final ExtensionPointName<PsiElementFinder> EP_NAME = ExtensionPointName.create((String)"com.intellij.java.elementFinder");

    @Nullable
    public abstract PsiClass findClass(@NotNull String var1, @NotNull GlobalSearchScope var2);

    @NotNull
    public abstract PsiClass[] findClasses(@NotNull String var1, @NotNull GlobalSearchScope var2);

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        return null;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        return PsiPackage.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        return PsiClass.EMPTY_ARRAY;
    }

    @Nullable
    public Condition<PsiClass> getClassesFilter(@NotNull GlobalSearchScope scope) {
        return null;
    }

    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        return PsiFile.EMPTY_ARRAY;
    }

    @Nullable
    public Condition<PsiFile> getPackageFilesFilter(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        return null;
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        return PsiElementFinder.getClassNames(this.getClasses(psiPackage, scope));
    }

    @NotNull
    protected static Set<String> getClassNames(@NotNull PsiClass[] classes) {
        if (classes.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        for (PsiClass aClass : classes) {
            ContainerUtil.addIfNotNull((Object)aClass.getName(), names);
        }
        return names;
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiDirectory> consumer) {
        return this.processPackageDirectories(psiPackage, scope, consumer, false);
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        return true;
    }

    @NotNull
    public PsiClass[] getClasses(@Nullable String className, @NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        PsiClass[] allClasses = this.getClasses(psiPackage, scope);
        if (className == null) {
            return allClasses;
        }
        return PsiElementFinder.filterByName(className, allClasses);
    }

    @NotNull
    public static PsiClass[] filterByName(@NotNull String className, @NotNull PsiClass[] classes) {
        if (classes.length == 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        if (classes.length == 1) {
            return className.equals(classes[0].getName()) ? classes : PsiClass.EMPTY_ARRAY;
        }
        SmartList foundClasses = new SmartList();
        for (PsiClass psiClass : classes) {
            if (!className.equals(psiClass.getName())) continue;
            foundClasses.add(psiClass);
        }
        return foundClasses.isEmpty() ? PsiClass.EMPTY_ARRAY : foundClasses.toArray(new PsiClass[foundClasses.size()]);
    }
}

