/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.CommonBundle;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class PsiBundle {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    private static final String BUNDLE = "messages.PsiBundle";

    public static String message(@NotNull @PropertyKey(resourceBundle="messages.PsiBundle") String key, Object ... params) {
        return CommonBundle.message((ResourceBundle)PsiBundle.getBundle(), (String)key, (Object[])params);
    }

    private PsiBundle() {
    }

    private static ResourceBundle getBundle() {
        ResourceBundle bundle = (ResourceBundle)SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    @NotNull
    public static String visibilityPresentation(@NotNull String modifier) {
        return PsiBundle.message(modifier + ".visibility.presentation", new Object[0]);
    }
}

