/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class VirtualFilePattern
extends TreeElementPattern<VirtualFile, VirtualFile, VirtualFilePattern> {
    public VirtualFilePattern() {
        super(VirtualFile.class);
    }

    public VirtualFilePattern ofType(final FileType type) {
        return (VirtualFilePattern)this.with(new PatternCondition<VirtualFile>("ofType"){

            @Override
            public boolean accepts(@NotNull VirtualFile virtualFile, ProcessingContext context) {
                return type.equals(virtualFile.getFileType());
            }
        });
    }

    public VirtualFilePattern withName(String name) {
        return this.withName((ElementPattern<String>)PlatformPatterns.string().equalTo(name));
    }

    public VirtualFilePattern withExtension(final String ... alternatives) {
        return (VirtualFilePattern)this.with(new PatternCondition<VirtualFile>("withExtension"){

            @Override
            public boolean accepts(@NotNull VirtualFile virtualFile, ProcessingContext context) {
                String extension = virtualFile.getExtension();
                for (String alternative : alternatives) {
                    if (!alternative.equals(extension)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public VirtualFilePattern withExtension(final @NotNull String extension) {
        return (VirtualFilePattern)this.with(new PatternCondition<VirtualFile>("withExtension"){

            @Override
            public boolean accepts(@NotNull VirtualFile virtualFile, ProcessingContext context) {
                return extension.equals(virtualFile.getExtension());
            }
        });
    }

    public VirtualFilePattern withName(final ElementPattern<String> namePattern) {
        return (VirtualFilePattern)this.with(new PatternCondition<VirtualFile>("withName"){

            @Override
            public boolean accepts(@NotNull VirtualFile virtualFile, ProcessingContext context) {
                return namePattern.accepts(virtualFile.getName(), context);
            }
        });
    }

    public VirtualFilePattern withPath(final ElementPattern<String> pathPattern) {
        return (VirtualFilePattern)this.with(new PatternCondition<VirtualFile>("withName"){

            @Override
            public boolean accepts(@NotNull VirtualFile virtualFile, ProcessingContext context) {
                return pathPattern.accepts(virtualFile.getPath(), context);
            }
        });
    }

    @Override
    protected VirtualFile getParent(@NotNull VirtualFile t) {
        return t.getParent();
    }

    protected VirtualFile[] getChildren(@NotNull VirtualFile file) {
        return file.getChildren();
    }
}

