/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiModifierListOwnerPattern<T extends PsiModifierListOwner, Self extends PsiModifierListOwnerPattern<T, Self>>
extends PsiElementPattern<T, Self> {
    public PsiModifierListOwnerPattern(@NotNull InitialPatternCondition<T> condition) {
        super(condition);
    }

    protected PsiModifierListOwnerPattern(Class<T> aClass) {
        super(aClass);
    }

    public Self withModifiers(final String ... modifiers) {
        return (Self)((PsiModifierListOwnerPattern)this.with(new PatternCondition<T>("withModifiers"){

            @Override
            public boolean accepts(final @NotNull T t, ProcessingContext context) {
                return ContainerUtil.and((Object[])modifiers, (Condition)new Condition<String>(){

                    public boolean value(String s) {
                        return t.hasModifierProperty(s);
                    }
                });
            }
        }));
    }

    public Self withoutModifiers(final String ... modifiers) {
        return (Self)((PsiModifierListOwnerPattern)this.with(new PatternCondition<T>("withoutModifiers"){

            @Override
            public boolean accepts(final @NotNull T t, ProcessingContext context) {
                return ContainerUtil.and((Object[])modifiers, (Condition)new Condition<String>(){

                    public boolean value(String s) {
                        return !t.hasModifierProperty(s);
                    }
                });
            }
        }));
    }

    public Self withAnnotation(final @NonNls String qualifiedName) {
        return (Self)((PsiModifierListOwnerPattern)this.with(new PatternCondition<T>("withAnnotation"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                PsiModifierList modifierList = t.getModifierList();
                return modifierList != null && modifierList.findAnnotation(qualifiedName) != null;
            }
        }));
    }

    public Self withAnnotations(final String ... qualifiedNames) {
        return (Self)((PsiModifierListOwnerPattern)this.with(new PatternCondition<T>("withAnnotations"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                return AnnotationUtil.findAnnotation(t, qualifiedNames) != null;
            }
        }));
    }

    public static class Capture<T extends PsiModifierListOwner>
    extends PsiModifierListOwnerPattern<T, Capture<T>> {
        public Capture(@NotNull InitialPatternCondition<T> condition) {
            super(condition);
        }
    }
}

