/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.artifacts;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import com.intellij.packaging.ui.PackagingSourceItem;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArtifactType {
    public static final ExtensionPointName<ArtifactType> EP_NAME = ExtensionPointName.create((String)"com.intellij.packaging.artifactType");
    private final String myId;
    private final String myTitle;

    protected ArtifactType(@NonNls String id, String title) {
        this.myId = id;
        this.myTitle = title;
    }

    public final String getId() {
        return this.myId;
    }

    public String getPresentableName() {
        return this.myTitle;
    }

    @NotNull
    public abstract Icon getIcon();

    @Nullable
    public String getDefaultPathFor(@NotNull PackagingSourceItem sourceItem) {
        return this.getDefaultPathFor(sourceItem.getKindOfProducedElements());
    }

    @Nullable
    public abstract String getDefaultPathFor(@NotNull PackagingElementOutputKind var1);

    public boolean isSuitableItem(@NotNull PackagingSourceItem sourceItem) {
        return true;
    }

    public static ArtifactType[] getAllTypes() {
        return (ArtifactType[])Extensions.getExtensions(EP_NAME);
    }

    @Nullable
    public static ArtifactType findById(@NotNull @NonNls String id) {
        for (ArtifactType type : ArtifactType.getAllTypes()) {
            if (!id.equals(type.getId())) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public abstract CompositePackagingElement<?> createRootElement(@NotNull String var1);

    @NotNull
    public List<? extends ArtifactTemplate> getNewArtifactTemplates(@NotNull PackagingElementResolvingContext context) {
        return Collections.emptyList();
    }

    public void checkRootElement(@NotNull CompositePackagingElement<?> rootElement, @NotNull Artifact artifact, @NotNull ArtifactProblemsHolder manager) {
    }

    @Nullable
    public List<? extends PackagingElement<?>> getSubstitution(@NotNull Artifact artifact, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType parentType) {
        return null;
    }
}

