/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class PassThroughIdeFocusManager
extends IdeFocusManager {
    private static final PassThroughIdeFocusManager ourInstance = new PassThroughIdeFocusManager();

    public static PassThroughIdeFocusManager getInstance() {
        return ourInstance;
    }

    @Override
    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        c.requestFocus();
        return ActionCallback.DONE;
    }

    @Override
    @NotNull
    public ActionCallback requestFocus(@NotNull FocusCommand command, boolean forced) {
        return command.run();
    }

    @Override
    public JComponent getFocusTargetFor(@NotNull JComponent comp) {
        return comp;
    }

    @Override
    public void doWhenFocusSettlesDown(@NotNull Runnable runnable) {
        runnable.run();
    }

    @Override
    public void doWhenFocusSettlesDown(@NotNull ExpirableRunnable runnable) {
        if (!runnable.isExpired()) {
            runnable.run();
        }
    }

    @Override
    public Component getFocusedDescendantFor(Component comp) {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused == null) {
            return null;
        }
        if (focused == comp || SwingUtilities.isDescendingFrom(focused, comp)) {
            return focused;
        }
        return null;
    }

    @Override
    public boolean dispatch(@NotNull KeyEvent e) {
        return false;
    }

    @Override
    public void typeAheadUntil(ActionCallback done) {
    }

    @Override
    @NotNull
    public ActionCallback requestDefaultFocus(boolean forced) {
        return ActionCallback.DONE;
    }

    @Override
    public boolean isFocusTransferEnabled() {
        return true;
    }

    @Override
    @NotNull
    public Expirable getTimestamp(boolean trackOnlyForcedCommands) {
        return new Expirable(){

            @Override
            public boolean isExpired() {
                return false;
            }
        };
    }

    @Override
    @NotNull
    public FocusRequestor getFurtherRequestor() {
        return this;
    }

    @Override
    public void revalidateFocus(@NotNull ExpirableRunnable runnable) {
    }

    @Override
    public void setTypeaheadEnabled(boolean enabled) {
    }

    @Override
    public Component getFocusOwner() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    @Override
    public void runOnOwnContext(@NotNull DataContext context, @NotNull Runnable runnable) {
        runnable.run();
    }

    @Override
    public Component getLastFocusedFor(IdeFrame frame) {
        return null;
    }

    @Override
    public IdeFrame getLastFocusedFrame() {
        return null;
    }

    @Override
    public void toFront(JComponent c) {
    }

    @Override
    public boolean isFocusBeingTransferred() {
        return false;
    }

    public void dispose() {
    }
}

