/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.ByteArrayCharSequence;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchiveHandler {
    public static final long DEFAULT_LENGTH = 0L;
    public static final long DEFAULT_TIMESTAMP = -1L;
    private final File myPath;
    private final Object myLock = new Object();
    private volatile Reference<Map<String, EntryInfo>> myEntries = new SoftReference(null);
    private boolean myCorrupted;

    protected ArchiveHandler(@NotNull String path2) {
        this.myPath = new File(path2);
    }

    @NotNull
    public File getFile() {
        return this.myPath;
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull String relativePath) {
        if (relativePath.isEmpty()) {
            FileAttributes attributes = FileSystemUtil.getAttributes((File)this.myPath);
            return attributes != null ? new FileAttributes(true, false, false, false, 0L, -1L, false) : null;
        }
        EntryInfo entry = this.getEntryInfo(relativePath);
        return entry != null ? new FileAttributes(entry.isDirectory, false, false, false, entry.length, entry.timestamp, false) : null;
    }

    @NotNull
    public String[] list(@NotNull String relativePath) {
        EntryInfo entry = this.getEntryInfo(relativePath);
        if (entry == null || !entry.isDirectory) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        THashSet names = new THashSet();
        for (EntryInfo info : this.getEntriesMap().values()) {
            if (info.parent != entry) continue;
            names.add(info.shortName.toString());
        }
        return ArrayUtil.toStringArray((Collection)names);
    }

    public void dispose() {
        this.myEntries.clear();
    }

    @Nullable
    protected EntryInfo getEntryInfo(@NotNull String relativePath) {
        return this.getEntriesMap().get(relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, EntryInfo> getEntriesMap() {
        Map<Object, Object> map = (Map)SoftReference.dereference(this.myEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = (Map)SoftReference.dereference(this.myEntries);
                if (map == null) {
                    if (this.myCorrupted) {
                        map = Collections.emptyMap();
                    } else {
                        try {
                            map = this.createEntriesMap();
                        }
                        catch (Exception e) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e.getMessage() + ": " + this.myPath, (Throwable)e);
                            map = Collections.emptyMap();
                        }
                    }
                    this.myEntries = new SoftReference(map);
                }
            }
        }
        return map;
    }

    @NotNull
    protected abstract Map<String, EntryInfo> createEntriesMap() throws IOException;

    @NotNull
    protected EntryInfo createRootEntry() {
        return new EntryInfo("", true, 0L, -1L, null);
    }

    @NotNull
    protected EntryInfo getOrCreate(@NotNull Map<String, EntryInfo> map, @NotNull String entryName) {
        EntryInfo entry = map.get(entryName);
        if (entry == null) {
            Pair<String, String> path2 = this.splitPath(entryName);
            EntryInfo parentEntry = this.getOrCreate(map, (String)path2.first);
            CharSequence shortName = ByteArrayCharSequence.convertToBytesIfAsciiString((String)((String)path2.second));
            entry = new EntryInfo(shortName, true, 0L, -1L, parentEntry);
            map.put(entryName, entry);
        }
        return entry;
    }

    @NotNull
    protected Pair<String, String> splitPath(@NotNull String entryName) {
        int p = entryName.lastIndexOf(47);
        String parentName = p > 0 ? entryName.substring(0, p) : "";
        String shortName = p > 0 ? entryName.substring(p + 1) : entryName;
        return Pair.create((Object)parentName, (Object)shortName);
    }

    @NotNull
    public abstract byte[] contentsToByteArray(@NotNull String var1) throws IOException;

    protected static class EntryInfo {
        public final EntryInfo parent;
        public final CharSequence shortName;
        public final boolean isDirectory;
        public final long length;
        public final long timestamp;

        public EntryInfo(EntryInfo parent, @NotNull String shortName, boolean isDirectory, long length, long timestamp) {
            this(shortName, isDirectory, length, timestamp, parent);
        }

        public EntryInfo(@NotNull CharSequence shortName, boolean isDirectory, long length, long timestamp, @Nullable EntryInfo parent) {
            this.parent = parent;
            this.shortName = shortName;
            this.isDirectory = isDirectory;
            this.length = length;
            this.timestamp = timestamp;
        }
    }
}

