/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.DistinctRootsCollection;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.text.StringFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsUtilCore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.VfsUtilCore");
    @NonNls
    private static final String MAILTO = "mailto";
    public static final String LOCALHOST_URI_PATH_PREFIX = "localhost/";
    public static final char VFS_SEPARATOR_CHAR = '/';
    private static final String PROTOCOL_DELIMITER = ":";

    public static boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile file, boolean strict) {
        VirtualFile parent;
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return false;
        }
        VirtualFile virtualFile = parent = strict ? file.getParent() : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isUnder(@NotNull VirtualFile file, @Nullable Set<VirtualFile> roots) {
        if (roots == null || roots.isEmpty()) {
            return false;
        }
        for (VirtualFile parent = file; parent != null; parent = parent.getParent()) {
            if (!roots.contains(parent)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnder(@NotNull String url, @Nullable Collection<String> rootUrls) {
        if (rootUrls == null || rootUrls.isEmpty()) {
            return false;
        }
        for (String excludesUrl : rootUrls) {
            if (!VfsUtilCore.isEqualOrAncestor(excludesUrl, url)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqualOrAncestor(@NotNull String ancestorUrl, @NotNull String fileUrl) {
        if (ancestorUrl.equals(fileUrl)) {
            return true;
        }
        if (StringUtil.endsWithChar((CharSequence)ancestorUrl, (char)'/')) {
            return fileUrl.startsWith(ancestorUrl);
        }
        return StringUtil.startsWithConcatenation((String)fileUrl, (String[])new String[]{ancestorUrl, "/"});
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file, boolean strict) {
        return FileUtil.isAncestor((File)ancestor, (File)file, (boolean)strict);
    }

    @Nullable
    public static String getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile ancestor) {
        return VfsUtilCore.getRelativePath(file, ancestor, '/');
    }

    @Nullable
    public static String getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile ancestor, char separator) {
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return null;
        }
        int length = 0;
        VirtualFile parent = file;
        while (true) {
            if (parent == null) {
                return null;
            }
            if (parent.equals(ancestor)) break;
            if (length > 0) {
                ++length;
            }
            length += parent.getNameSequence().length();
            parent = parent.getParent();
        }
        char[] chars = new char[length];
        int index = chars.length;
        parent = file;
        while (!parent.equals(ancestor)) {
            if (index < length) {
                chars[--index] = separator;
            }
            CharSequence name = parent.getNameSequence();
            for (int i = name.length() - 1; i >= 0; --i) {
                chars[--index] = name.charAt(i);
            }
            parent = parent.getParent();
        }
        return StringFactory.createShared((char[])chars);
    }

    @Nullable
    public static VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path2 = entryVFile.getPath();
        int separatorIndex = path2.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path2.substring(0, separatorIndex);
        return VirtualFileManager.getInstance().findFileByUrl("file://" + localPath);
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        return VfsUtilCore.copyFile(requestor, file, toDir, file.getName());
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull @NonNls String newName) throws IOException {
        VirtualFile newChild = toDir.createChildData(requestor, newName);
        newChild.setBinaryContent(file.contentsToByteArray());
        return newChild;
    }

    @NotNull
    public static InputStream byteStreamSkippingBOM(@NotNull byte[] buf, @NotNull VirtualFile file) throws IOException {
        BufferExposingByteArrayInputStream stream = new BufferExposingByteArrayInputStream(buf);
        return VfsUtilCore.inputStreamSkippingBOM((InputStream)stream, file);
    }

    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream, @NotNull VirtualFile file) throws IOException {
        return CharsetToolkit.inputStreamSkippingBOM((InputStream)stream);
    }

    @NotNull
    public static OutputStream outputStreamAddingBOM(@NotNull OutputStream stream, @NotNull VirtualFile file) throws IOException {
        byte[] bom = file.getBOM();
        if (bom != null) {
            stream.write(bom);
        }
        return stream;
    }

    public static boolean iterateChildrenRecursively(final @NotNull VirtualFile root, final @Nullable VirtualFileFilter filter, final @NotNull ContentIterator iterator) {
        VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (filter != null && !filter.accept(file)) {
                    return SKIP_CHILDREN;
                }
                if (!iterator.processFile(file)) {
                    return 1.skipTo(root);
                }
                return CONTINUE;
            }
        });
        return !Comparing.equal((Object)result.skipToParent, (Object)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor<?> visitor) throws VirtualFileVisitor.VisitorException {
        boolean pushed = false;
        try {
            boolean visited = visitor.allowVisitFile(file);
            if (visited) {
                VirtualFileVisitor.Result result = visitor.visitFileEx(file);
                if (result.skipChildren) {
                    VirtualFileVisitor.Result result2 = result;
                    return result2;
                }
            }
            Iterable<VirtualFile> childrenIterable = null;
            VirtualFile[] children = null;
            try {
                if (file.isValid() && visitor.allowVisitChildren(file) && !visitor.depthLimitReached() && (childrenIterable = visitor.getChildrenIterable(file)) == null) {
                    children = file.getChildren();
                }
            }
            catch (InvalidVirtualFileAccessException e) {
                LOG.info("Ignoring: " + e.getMessage());
                VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
                visitor.restoreValue(pushed);
                return result;
            }
            if (childrenIterable != null) {
                visitor.saveValue();
                pushed = true;
                for (VirtualFile child : childrenIterable) {
                    VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(child, visitor);
                    if (result.skipToParent == null || Comparing.equal((Object)result.skipToParent, (Object)child)) continue;
                    VirtualFileVisitor.Result result3 = result;
                    return result3;
                }
            } else if (children != null && children.length != 0) {
                visitor.saveValue();
                pushed = true;
                for (VirtualFile child : children) {
                    VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(child, visitor);
                    if (result.skipToParent == null || Comparing.equal((Object)result.skipToParent, (Object)child)) continue;
                    VirtualFileVisitor.Result result4 = result;
                    return result4;
                }
            }
            if (visited) {
                visitor.afterChildrenVisited(file);
            }
            VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
            return result;
        }
        finally {
            visitor.restoreValue(pushed);
        }
    }

    public static <E extends Exception> VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor visitor, @NotNull Class<E> eClass) throws E {
        try {
            return VfsUtilCore.visitChildrenRecursively(file, visitor);
        }
        catch (VirtualFileVisitor.VisitorException e) {
            Throwable cause = e.getCause();
            if (eClass.isInstance(cause)) {
                throw (Exception)eClass.cast(cause);
            }
            throw e;
        }
    }

    public static boolean isBrokenLink(@NotNull VirtualFile file) {
        return file.is(VFileProperty.SYMLINK) && file.getCanonicalPath() == null;
    }

    public static boolean isInvalidLink(@NotNull VirtualFile link) {
        VirtualFile target = link.getCanonicalFile();
        return target == null || target.equals(link) || VfsUtilCore.isAncestor(target, link, true);
    }

    @NotNull
    public static String loadText(@NotNull VirtualFile file) throws IOException {
        return VfsUtilCore.loadText(file, (int)file.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String loadText(@NotNull VirtualFile file, int length) throws IOException {
        InputStreamReader reader = new InputStreamReader(file.getInputStream(), file.getCharset());
        try {
            String string = StringFactory.createShared((char[])FileUtil.loadText((Reader)reader, (int)length));
            return string;
        }
        finally {
            reader.close();
        }
    }

    @NotNull
    public static VirtualFile[] toVirtualFileArray(@NotNull Collection<? extends VirtualFile> files) {
        int size = files.size();
        if (size == 0) {
            return VirtualFile.EMPTY_ARRAY;
        }
        return files.toArray(new VirtualFile[size]);
    }

    @NotNull
    public static String urlToPath(@NonNls @Nullable String url) {
        if (url == null) {
            return "";
        }
        return VirtualFileManager.extractPath(url);
    }

    @NotNull
    public static File virtualToIoFile(@NotNull VirtualFile file) {
        return new File(PathUtil.toPresentableUrl(file.getUrl()));
    }

    @NotNull
    public static String pathToUrl(@NonNls @NotNull String path2) {
        return VirtualFileManager.constructUrl("file", path2);
    }

    public static List<File> virtualToIoFiles(@NotNull Collection<VirtualFile> scope) {
        return ContainerUtil.map2List(scope, (Function)new Function<VirtualFile, File>(){

            public File fun(VirtualFile file) {
                return VfsUtilCore.virtualToIoFile(file);
            }
        });
    }

    @NotNull
    public static String toIdeaUrl(@NotNull String url) {
        return VfsUtilCore.toIdeaUrl(url, true);
    }

    @NotNull
    public static String toIdeaUrl(@NotNull String url, boolean removeLocalhostPrefix) {
        int index = url.indexOf(":/");
        if (index < 0 || index + 2 >= url.length()) {
            return url;
        }
        if (url.charAt(index + 2) != '/') {
            String prefix = url.substring(0, index);
            String suffix = url.substring(index + 2);
            if (SystemInfoRt.isWindows) {
                return prefix + "://" + suffix;
            }
            if (removeLocalhostPrefix && prefix.equals("file") && suffix.startsWith(LOCALHOST_URI_PATH_PREFIX)) {
                return prefix + ":///" + suffix.substring(LOCALHOST_URI_PATH_PREFIX.length());
            }
            return prefix + ":///" + suffix;
        }
        if (SystemInfoRt.isWindows && index + 3 < url.length() && url.charAt(index + 3) == '/' && url.regionMatches(0, "file://", 0, "file://".length())) {
            char c;
            for (int i = index + 4; i < url.length() && (c = url.charAt(i)) != '/'; ++i) {
                if (c != ':') continue;
                return "file://" + url.substring(index + 4);
            }
            return url;
        }
        return url;
    }

    @NotNull
    public static String fixURLforIDEA(@NotNull String url) {
        return VfsUtilCore.toIdeaUrl(url, false);
    }

    @NotNull
    public static String convertFromUrl(@NotNull URL url) {
        String protocol = url.getProtocol();
        String path2 = url.getPath();
        if (protocol.equals("jar")) {
            if (StringUtil.startsWithConcatenation((String)path2, (String[])new String[]{"file", PROTOCOL_DELIMITER})) {
                try {
                    URL subURL = new URL(path2);
                    path2 = subURL.getPath();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(VfsBundle.message("url.parse.unhandled.exception", new Object[0]), e);
                }
            } else {
                throw new RuntimeException(new IOException(VfsBundle.message("url.parse.error", url.toExternalForm())));
            }
        }
        if (SystemInfo.isWindows || SystemInfo.isOS2) {
            while (!path2.isEmpty() && path2.charAt(0) == '/') {
                path2 = path2.substring(1, path2.length());
            }
        }
        path2 = URLUtil.unescapePercentSequences((String)path2);
        return protocol + "://" + path2;
    }

    @Nullable
    public static URL convertToURL(@NotNull String vfsUrl) {
        if (vfsUrl.startsWith("jar://")) {
            try {
                return new URL("jar:file:///" + vfsUrl.substring("jar://".length()));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (vfsUrl.startsWith(MAILTO)) {
            try {
                return new URL(vfsUrl);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        String[] split = vfsUrl.split("://");
        if (split.length != 2) {
            LOG.debug("Malformed VFS URL: " + vfsUrl);
            return null;
        }
        String protocol = split[0];
        String path2 = split[1];
        try {
            if (protocol.equals("file")) {
                return new URL("file", "", path2);
            }
            return UrlClassLoader.internProtocol((URL)new URL(vfsUrl));
        }
        catch (MalformedURLException e) {
            LOG.debug("MalformedURLException occurred:" + e.getMessage());
            return null;
        }
    }

    @NotNull
    public static String fixIDEAUrl(@NotNull String ideaUrl) {
        String ideaProtocolMarker = "://";
        int idx = ideaUrl.indexOf("://");
        if (idx >= 0) {
            String s = ideaUrl.substring(0, idx);
            if (s.equals("jar")) {
                s = "jar:file";
            }
            String urlWithoutProtocol = ideaUrl.substring(idx + "://".length());
            ideaUrl = s + PROTOCOL_DELIMITER + (urlWithoutProtocol.startsWith("/") ? "" : "/") + urlWithoutProtocol;
        }
        return ideaUrl;
    }

    @Nullable
    public static VirtualFile findRelativeFile(@NotNull String uri, @Nullable VirtualFile base) {
        if (base != null && !base.isValid()) {
            LOG.error("Invalid file name: " + base.getName() + ", url: " + uri);
        }
        if ((uri = uri.replace('\\', '/')).startsWith("file:///")) {
            uri = uri.substring("file:///".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
        } else if (uri.startsWith("file:/")) {
            uri = uri.substring("file:/".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
        } else {
            uri = StringUtil.trimStart((String)uri, (String)"file:");
        }
        VirtualFile file = null;
        if (uri.startsWith("jar:file:/")) {
            uri = uri.substring("jar:file:/".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
            file = VirtualFileManager.getInstance().findFileByUrl("jar://" + uri);
        } else if (!SystemInfo.isWindows && StringUtil.startsWithChar((CharSequence)uri, (char)'/')) {
            file = StandardFileSystems.local().findFileByPath(uri);
        } else if (SystemInfo.isWindows && uri.length() >= 2 && Character.isLetter(uri.charAt(0)) && uri.charAt(1) == ':') {
            file = StandardFileSystems.local().findFileByPath(uri);
        }
        if (file == null && uri.contains("!/") && (file = StandardFileSystems.jar().findFileByPath(uri)) == null && base == null) {
            file = VirtualFileManager.getInstance().findFileByUrl(uri);
        }
        if (file == null) {
            if (base == null) {
                return StandardFileSystems.local().findFileByPath(uri);
            }
            if (!base.isDirectory()) {
                base = base.getParent();
            }
            if (base == null) {
                return StandardFileSystems.local().findFileByPath(uri);
            }
            file = VirtualFileManager.getInstance().findFileByUrl(base.getUrl() + "/" + uri);
            if (file == null) {
                return null;
            }
        }
        return file;
    }

    public static boolean processFilesRecursively(@NotNull VirtualFile root, @NotNull Processor<VirtualFile> processor) {
        if (!processor.process((Object)root)) {
            return false;
        }
        if (root.isDirectory()) {
            LinkedList<VirtualFile[]> queue = new LinkedList<VirtualFile[]>();
            queue.add(root.getChildren());
            do {
                VirtualFile[] files;
                for (VirtualFile file : files = (VirtualFile[])queue.removeFirst()) {
                    if (!processor.process((Object)file)) {
                        return false;
                    }
                    if (!file.isDirectory()) continue;
                    queue.add(file.getChildren());
                }
            } while (!queue.isEmpty());
        }
        return true;
    }

    @Nullable
    public static VirtualFile getCommonAncestor(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (!file1.getFileSystem().equals(file2.getFileSystem())) {
            return null;
        }
        VirtualFile[] path1 = VfsUtilCore.getPathComponents(file1);
        VirtualFile[] path2 = VfsUtilCore.getPathComponents(file2);
        int lastEqualIdx = -1;
        int i = 0;
        while (i < path1.length && i < path2.length && path1[i].equals(path2[i])) {
            lastEqualIdx = i++;
        }
        return lastEqualIdx == -1 ? null : path1[lastEqualIdx];
    }

    @NotNull
    static VirtualFile[] getPathComponents(@NotNull VirtualFile file) {
        ArrayList<VirtualFile> componentsList = new ArrayList<VirtualFile>();
        while (file != null) {
            componentsList.add(file);
            file = file.getParent();
        }
        int size = componentsList.size();
        VirtualFile[] components = new VirtualFile[size];
        for (int i = 0; i < size; ++i) {
            components[i] = (VirtualFile)componentsList.get(size - i - 1);
        }
        return components;
    }

    public static void processFilesRecursively(@NotNull VirtualFile root, @NotNull Processor<VirtualFile> processor, @NotNull Convertor<VirtualFile, Boolean> directoryFilter) {
        if (!processor.process((Object)root)) {
            return;
        }
        if (root.isDirectory() && ((Boolean)directoryFilter.convert((Object)root)).booleanValue()) {
            LinkedList<VirtualFile[]> queue = new LinkedList<VirtualFile[]>();
            queue.add(root.getChildren());
            do {
                VirtualFile[] files;
                for (VirtualFile file : files = (VirtualFile[])queue.removeFirst()) {
                    if (!processor.process((Object)file)) {
                        return;
                    }
                    if (!file.isDirectory() || !((Boolean)directoryFilter.convert((Object)file)).booleanValue()) continue;
                    queue.add(file.getChildren());
                }
            } while (!queue.isEmpty());
        }
    }

    public static class DistinctVFilesRootsCollection
    extends DistinctRootsCollection<VirtualFile> {
        public DistinctVFilesRootsCollection() {
        }

        public DistinctVFilesRootsCollection(Collection<VirtualFile> virtualFiles) {
            super(virtualFiles);
        }

        public DistinctVFilesRootsCollection(VirtualFile[] collection) {
            super((Object[])collection);
        }

        protected boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile virtualFile) {
            return VfsUtilCore.isAncestor(ancestor, virtualFile, false);
        }
    }
}

