/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AsyncValueLoaderManager<HOST, VALUE> {
    private final AtomicFieldUpdater<HOST, AsyncResult<VALUE>> fieldUpdater;

    public AsyncValueLoaderManager(@NotNull AtomicFieldUpdater<HOST, AsyncResult<VALUE>> fieldUpdater) {
        this.fieldUpdater = fieldUpdater;
    }

    public AsyncValueLoaderManager(@NotNull Class<HOST> ownerClass) {
        this.fieldUpdater = AtomicFieldUpdater.forFieldOfType(ownerClass, AsyncResult.class);
    }

    public boolean isUpToDate(@NotNull HOST host, @NotNull VALUE value) {
        return true;
    }

    public abstract void load(@NotNull HOST var1, @NotNull AsyncResult<VALUE> var2);

    public final void reset(HOST host) {
        this.fieldUpdater.set(host, null);
    }

    public final void set(HOST host, @Nullable VALUE value) {
        if (value == null) {
            this.reset(host);
        } else {
            this.getOrCreateAsyncResult(host, false, false).setDone(value);
        }
    }

    public final boolean has(HOST host) {
        AsyncResult result = (AsyncResult)this.fieldUpdater.get(host);
        return result != null && result.isDone() && result.getResult() != null;
    }

    @NotNull
    public final AsyncResult<VALUE> get(HOST host) {
        return this.get(host, true);
    }

    public final AsyncResult<VALUE> get(HOST host, boolean checkFreshness) {
        return this.getOrCreateAsyncResult(host, checkFreshness, true);
    }

    private AsyncResult<VALUE> getOrCreateAsyncResult(HOST host, boolean checkFreshness, boolean load) {
        AsyncResult asyncResult = (AsyncResult)this.fieldUpdater.get(host);
        if (asyncResult == null) {
            asyncResult = new AsyncResult();
            if (!this.fieldUpdater.compareAndSet(host, null, asyncResult)) {
                return (AsyncResult)this.fieldUpdater.get(host);
            }
        } else {
            if (!asyncResult.isProcessed()) {
                return asyncResult;
            }
            if (asyncResult.isDone()) {
                if (!checkFreshness || this.isUpToDate(host, asyncResult.getResult())) {
                    return asyncResult;
                }
                if (!this.fieldUpdater.compareAndSet(host, asyncResult, asyncResult = new AsyncResult())) {
                    AsyncResult valueFromAnotherThread = (AsyncResult)this.fieldUpdater.get(host);
                    while (valueFromAnotherThread == null) {
                        if (this.fieldUpdater.compareAndSet(host, null, asyncResult)) {
                            if (load) {
                                this.load(host, asyncResult);
                            }
                            return asyncResult;
                        }
                        valueFromAnotherThread = (AsyncResult)this.fieldUpdater.get(host);
                    }
                    return valueFromAnotherThread;
                }
            }
        }
        if (load) {
            this.load(host, asyncResult);
        }
        return asyncResult;
    }
}

