/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.mac.MacMessages;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MessageDialogBuilder<T extends MessageDialogBuilder> {
    protected final String myMessage;
    protected final String myTitle;
    protected String myYesText;
    protected String myNoText;
    protected Project myProject;
    protected Icon myIcon;
    protected DialogWrapper.DoNotAskOption myDoNotAskOption;

    private MessageDialogBuilder(@NotNull String title, @NotNull String message) {
        this.myTitle = title;
        this.myMessage = message;
    }

    @NotNull
    public static YesNo yesNo(@NotNull String title, @NotNull String message) {
        return (YesNo)new YesNo(title, message).icon(Messages.getQuestionIcon());
    }

    public static YesNoCancel yesNoCancel(@NotNull String title, @NotNull String message) {
        return (YesNoCancel)new YesNoCancel(title, message).icon(Messages.getQuestionIcon());
    }

    protected abstract T getThis();

    @NotNull
    public T project(@Nullable Project project) {
        this.myProject = project;
        return this.getThis();
    }

    public T icon(@Nullable Icon icon) {
        this.myIcon = icon;
        return this.getThis();
    }

    @NotNull
    public T doNotAsk(@NotNull DialogWrapper.DoNotAskOption doNotAskOption) {
        this.myDoNotAskOption = doNotAskOption;
        return this.getThis();
    }

    public T yesText(@NotNull String yesText) {
        this.myYesText = yesText;
        return this.getThis();
    }

    public T noText(@NotNull String noText) {
        this.myNoText = noText;
        return this.getThis();
    }

    public static final class YesNoCancel
    extends MessageDialogBuilder<YesNoCancel> {
        private String myCancelText;

        private YesNoCancel(@NotNull String title, @NotNull String message) {
            super(title, message);
        }

        public YesNoCancel cancelText(@NotNull String cancelText) {
            this.myCancelText = cancelText;
            return this.getThis();
        }

        @Override
        protected YesNoCancel getThis() {
            return this;
        }

        @Messages.YesNoCancelResult
        public int show() {
            String yesText = (String)ObjectUtils.chooseNotNull((Object)this.myYesText, (Object)Messages.YES_BUTTON);
            String noText = (String)ObjectUtils.chooseNotNull((Object)this.myNoText, (Object)Messages.NO_BUTTON);
            String cancelText = (String)ObjectUtils.chooseNotNull((Object)this.myCancelText, (Object)Messages.CANCEL_BUTTON);
            try {
                if (Messages.canShowMacSheetPanel() && !Messages.isApplicationInUnitTestOrHeadless()) {
                    return MacMessages.getInstance().showYesNoCancelDialog(this.myTitle, this.myMessage, yesText, noText, cancelText, WindowManager.getInstance().suggestParentWindow(this.myProject), this.myDoNotAskOption);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            int buttonNumber = Messages.showDialog(this.myProject, this.myMessage, this.myTitle, new String[]{yesText, noText, cancelText}, 0, this.myIcon, this.myDoNotAskOption);
            return buttonNumber == 0 ? 0 : (buttonNumber == 1 ? 1 : 2);
        }
    }

    public static final class YesNo
    extends MessageDialogBuilder<YesNo> {
        private YesNo(@NotNull String title, @NotNull String message) {
            super(title, message);
        }

        @Override
        protected YesNo getThis() {
            return this;
        }

        @Messages.YesNoResult
        public int show() {
            String yesText = (String)ObjectUtils.chooseNotNull((Object)this.myYesText, (Object)Messages.YES_BUTTON);
            String noText = (String)ObjectUtils.chooseNotNull((Object)this.myNoText, (Object)Messages.NO_BUTTON);
            try {
                if (Messages.canShowMacSheetPanel() && !Messages.isApplicationInUnitTestOrHeadless()) {
                    return MacMessages.getInstance().showYesNoDialog(this.myTitle, this.myMessage, yesText, noText, WindowManager.getInstance().suggestParentWindow(this.myProject), this.myDoNotAskOption);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Messages.showDialog(this.myProject, this.myMessage, this.myTitle, new String[]{yesText, noText}, 0, this.myIcon, this.myDoNotAskOption) == 0 ? 0 : 1;
        }

        public boolean is() {
            return this.show() == 0;
        }
    }
}

