/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightFilePointer
implements VirtualFilePointer {
    private final String myUrl;
    private VirtualFile myFile;

    public LightFilePointer(@NotNull String url) {
        this.myUrl = url;
    }

    public LightFilePointer(@NotNull VirtualFile file) {
        this.myUrl = file.getUrl();
        this.myFile = file;
    }

    @Override
    @Nullable
    public VirtualFile getFile() {
        this.refreshFile();
        return this.myFile;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.myUrl;
    }

    @Override
    @NotNull
    public String getFileName() {
        if (this.myFile != null) {
            return this.myFile.getName();
        }
        int index = this.myUrl.lastIndexOf(47);
        return index >= 0 ? this.myUrl.substring(index + 1) : this.myUrl;
    }

    @Override
    @NotNull
    public String getPresentableUrl() {
        VirtualFile file = this.getFile();
        if (file != null) {
            return file.getPresentableUrl();
        }
        return LightFilePointer.toPresentableUrl(this.myUrl);
    }

    public static String toPresentableUrl(String url) {
        String path2 = VirtualFileManager.extractPath(url);
        path2 = StringUtil.trimEnd((String)path2, (String)"!/");
        return path2.replace('/', File.separatorChar);
    }

    @Override
    public boolean isValid() {
        return this.getFile() != null;
    }

    private void refreshFile() {
        if (this.myFile != null && this.myFile.isValid()) {
            return;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
        this.myFile = virtualFile != null && virtualFile.isValid() ? virtualFile : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LightFilePointer)) {
            return false;
        }
        return this.myUrl.equals(((LightFilePointer)o).myUrl);
    }

    public int hashCode() {
        return this.myUrl.hashCode();
    }
}

