/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class UnknownSdkType
extends SdkType {
    private static final Map<String, UnknownSdkType> ourTypeNameToInstanceMap = new HashMap<String, UnknownSdkType>();

    private UnknownSdkType(@NotNull String typeName) {
        super(typeName);
    }

    @NotNull
    public static UnknownSdkType getInstance(@NotNull String typeName) {
        UnknownSdkType instance = ourTypeNameToInstanceMap.get(typeName);
        if (instance == null) {
            instance = new UnknownSdkType(typeName);
            ourTypeNameToInstanceMap.put(typeName, instance);
        }
        return instance;
    }

    @Override
    public String suggestHomePath() {
        return null;
    }

    @Override
    public boolean isValidSdkHome(String path2) {
        return false;
    }

    @Override
    public String getVersionString(String sdkHome) {
        return "";
    }

    @Override
    public String suggestSdkName(String currentSdkName, String sdkHome) {
        return currentSdkName;
    }

    @Override
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        return null;
    }

    public String getBinPath(Sdk sdk) {
        return null;
    }

    public String getToolsPath(Sdk sdk) {
        return null;
    }

    public String getVMExecutablePath(Sdk sdk) {
        return null;
    }

    @Override
    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return ProjectBundle.message("sdk.unknown.name", new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Nodes.UnknownJdk;
    }
}

