/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SimpleJavaSdkType
extends SdkType
implements JavaSdkType {
    @NonNls
    private static final String VM_EXE_NAME = "java";

    public SimpleJavaSdkType() {
        super("SimpleJavaSdkType");
    }

    public Sdk createJdk(String jdkName, String home) {
        Sdk jdk = ProjectJdkTable.getInstance().createSdk(jdkName, this);
        SdkModificator sdkModificator = jdk.getSdkModificator();
        String path2 = home.replace(File.separatorChar, '/');
        sdkModificator.setHomePath(path2);
        sdkModificator.commitChanges();
        return jdk;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return ProjectBundle.message("sdk.java.name", new Object[0]);
    }

    @Override
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        return null;
    }

    @Override
    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
    }

    @Override
    public String getBinPath(@NotNull Sdk sdk) {
        return SimpleJavaSdkType.getConvertedHomePath(sdk) + "bin";
    }

    @Override
    @NonNls
    public String getToolsPath(@NotNull Sdk sdk) {
        String versionString = sdk.getVersionString();
        boolean isJdk1_x = versionString != null && (versionString.contains("1.0") || versionString.contains("1.1"));
        return SimpleJavaSdkType.getConvertedHomePath(sdk) + "lib" + File.separator + (isJdk1_x ? "classes.zip" : "tools.jar");
    }

    @Override
    public String getVMExecutablePath(@NotNull Sdk sdk) {
        return this.getBinPath(sdk) + File.separator + VM_EXE_NAME;
    }

    private static String getConvertedHomePath(Sdk sdk) {
        String path2 = sdk.getHomePath().replace('/', File.separatorChar);
        if (!path2.endsWith(File.separator)) {
            path2 = path2 + File.separator;
        }
        return path2;
    }

    @Override
    public String suggestHomePath() {
        return null;
    }

    @Override
    public boolean isValidSdkHome(String path2) {
        return JdkUtil.checkForJdk(new File(path2));
    }

    @Override
    public String suggestSdkName(String currentSdkName, String sdkHome) {
        return currentSdkName;
    }

    @Override
    public final String getVersionString(String sdkHome) {
        return SdkVersionUtil.detectJdkVersion(sdkHome);
    }
}

