/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunBackgroundable {
    private RunBackgroundable() {
    }

    public static void run(@NotNull Task task) {
        ProgressManager pm = ProgressManager.getInstance();
        if (ApplicationManager.getApplication().isDispatchThread()) {
            pm.run(task);
        } else {
            RunBackgroundable.runIfBackgroundThread(task, pm.getProgressIndicator(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runIfBackgroundThread(final Task task, ProgressIndicator pi, @Nullable Runnable pooledContinuation) {
        boolean canceled = true;
        try {
            task.run(pi);
            canceled = pi != null && pi.isCanceled();
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        finally {
            if (pooledContinuation != null) {
                pooledContinuation.run();
            }
        }
        final boolean finalCanceled = canceled;
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (finalCanceled) {
                    task.onCancel();
                } else {
                    task.onSuccess();
                }
            }
        });
    }
}

