/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.AbstractTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ProgressManagerQueue
extends AbstractTaskQueue<Runnable> {
    private final ProgressManager myProgressManager = ProgressManager.getInstance();
    private final Task.Backgroundable myQueuePollTask;
    private volatile boolean myIsStarted;

    public ProgressManagerQueue(@NotNull Project project, @NotNull String title) {
        this.myQueuePollTask = new Task.Backgroundable(project, title){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                ProgressManagerQueue.this.myQueueWorker.run();
            }
        };
    }

    public void start() {
        this.myIsStarted = true;
        this.runMe();
    }

    @Override
    protected void runMe() {
        if (!this.myIsStarted) {
            return;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            if (!this.myQueuePollTask.myProject.isDisposed()) {
                this.myProgressManager.run(this.myQueuePollTask);
            }
        } else {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!((ProgressManagerQueue)ProgressManagerQueue.this).myQueuePollTask.myProject.isDisposed()) {
                        ProgressManagerQueue.this.myProgressManager.run(ProgressManagerQueue.this.myQueuePollTask);
                    }
                }
            });
        }
    }

    @Override
    protected void runStuff(Runnable stuff) {
        try {
            stuff.run();
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }
}

