/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.Convertor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SettingsEditorWrapper<Src, Dst>
extends SettingsEditor<Src> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.options.SettingsEditorWrapper");
    private final Convertor<Src, Dst> mySrcToDstConvertor;
    private final SettingsEditor<Dst> myWrapped;
    private final SettingsEditorListener<Dst> myListener;

    public SettingsEditorWrapper(SettingsEditor<Dst> wrapped, Convertor<Src, Dst> convertor) {
        this.mySrcToDstConvertor = convertor;
        this.myWrapped = wrapped;
        this.myListener = new SettingsEditorListener<Dst>(){

            @Override
            public void stateChanged(SettingsEditor<Dst> settingsEditor) {
                SettingsEditorWrapper.this.fireEditorStateChanged();
            }
        };
        this.myWrapped.addSettingsEditorListener(this.myListener);
    }

    @Override
    public void resetEditorFrom(Src src) {
        this.myWrapped.resetFrom(this.mySrcToDstConvertor.convert(src));
    }

    @Override
    public void applyEditorTo(Src src) throws ConfigurationException {
        this.myWrapped.applyTo(this.mySrcToDstConvertor.convert(src));
    }

    @Override
    @NotNull
    public JComponent createEditor() {
        return this.myWrapped.createEditor();
    }

    @Override
    public void disposeEditor() {
        this.myWrapped.removeSettingsEditorListener(this.myListener);
        Disposer.dispose(this.myWrapped);
    }
}

