/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchemesManagerFactory {
    @NotNull
    public <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> createSchemesManager(@NotNull String directoryName, @NotNull SchemeProcessor<E> processor, @NotNull RoamingType roamingType) {
        return this.create(directoryName, processor, roamingType, null);
    }

    @NotNull
    public final <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> create(@NotNull String directoryName, @NotNull SchemeProcessor<E> processor) {
        return this.create(directoryName, processor, RoamingType.DEFAULT, null);
    }

    @NotNull
    public final <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> create(@NotNull String directoryName, @NotNull SchemeProcessor<E> processor, @NotNull String presentableName) {
        return this.create(directoryName, processor, RoamingType.DEFAULT, presentableName);
    }

    protected abstract <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> create(@NotNull String var1, @NotNull SchemeProcessor<E> var2, @NotNull RoamingType var3, @Nullable String var4);

    @NotNull
    public static SchemesManagerFactory getInstance() {
        return ServiceManager.getService(SchemesManagerFactory.class);
    }

    @NotNull
    public static SchemesManagerFactory getInstance(@NotNull Project project) {
        return ServiceManager.getService(project, SchemesManagerFactory.class);
    }
}

