/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ThrowableConvertor;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchemesManager<T extends Scheme, E extends ExternalizableScheme> {
    @NotNull
    public abstract Collection<E> loadSchemes();

    public abstract void addNewScheme(@NotNull T var1, boolean var2);

    public void addScheme(@NotNull T scheme) {
        this.addNewScheme(scheme, true);
    }

    public abstract void clearAllSchemes();

    @NotNull
    public abstract List<T> getAllSchemes();

    @Nullable
    public abstract T findSchemeByName(@NotNull String var1);

    public final void setCurrentSchemeName(@Nullable String schemeName) {
        this.setCurrentSchemeName(schemeName, true);
    }

    public abstract void setCurrentSchemeName(@Nullable String var1, boolean var2);

    public final void setCurrent(@Nullable T scheme) {
        this.setCurrent(scheme, true);
    }

    public void setCurrent(@Nullable T scheme, boolean notify) {
        this.setCurrentSchemeName(scheme == null ? null : scheme.getName());
    }

    @Nullable
    public abstract T getCurrentScheme();

    @Nullable
    public String getCurrentSchemeName() {
        T scheme = this.getCurrentScheme();
        return scheme == null ? null : scheme.getName();
    }

    public abstract void removeScheme(@NotNull T var1);

    @NotNull
    public abstract Collection<String> getAllSchemeNames();

    public abstract File getRootDirectory();

    public void loadBundledScheme(@NotNull String resourceName, @NotNull Object requestor, @NotNull ThrowableConvertor<Element, T, Throwable> convertor) {
    }

    public final void setSchemes(@NotNull List<T> newSchemes) {
        this.setSchemes(newSchemes, null, null);
    }

    public final void setSchemes(@NotNull List<T> newSchemes, @Nullable T newCurrentScheme) {
        this.setSchemes(newSchemes, newCurrentScheme, null);
    }

    public void setSchemes(@NotNull List<T> newSchemes, @Nullable T newCurrentScheme, @Nullable Condition<T> removeCondition) {
    }

    public boolean isMetadataEditable(@NotNull E scheme) {
        return true;
    }
}

