/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.task;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskId
implements Serializable {
    @NotNull
    private static final AtomicLong COUNTER = new AtomicLong();
    private static final long serialVersionUID = 1L;
    @NotNull
    private final ExternalSystemTaskType myType;
    @NotNull
    private final String myProjectId;
    @NotNull
    private final ProjectSystemId myProjectSystemId;
    private final long myId;

    private ExternalSystemTaskId(@NotNull ProjectSystemId projectSystemId, @NotNull ExternalSystemTaskType type, @NotNull String projectId, long taskId) {
        this.myType = type;
        this.myProjectId = projectId;
        this.myProjectSystemId = projectSystemId;
        this.myId = taskId;
    }

    @NotNull
    public String getIdeProjectId() {
        return this.myProjectId;
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        return this.myProjectSystemId;
    }

    @NotNull
    public static ExternalSystemTaskId create(@NotNull ProjectSystemId projectSystemId, @NotNull ExternalSystemTaskType type, @NotNull Project project) {
        return ExternalSystemTaskId.create(projectSystemId, type, ExternalSystemTaskId.getProjectId(project));
    }

    @NotNull
    public static ExternalSystemTaskId create(@NotNull ProjectSystemId projectSystemId, @NotNull ExternalSystemTaskType type, @NotNull String ideProjectId) {
        return new ExternalSystemTaskId(projectSystemId, type, ideProjectId, COUNTER.getAndIncrement());
    }

    @NotNull
    public static String getProjectId(@NotNull Project project) {
        return project.isDisposed() ? project.getName() : project.getName() + ":" + project.getLocationHash();
    }

    @Nullable
    public Project findProject() {
        ProjectManager projectManager = ProjectManager.getInstance();
        for (Project project : projectManager.getOpenProjects()) {
            if (!this.myProjectId.equals(ExternalSystemTaskId.getProjectId(project))) continue;
            return project;
        }
        return null;
    }

    @NotNull
    public ExternalSystemTaskType getType() {
        return this.myType;
    }

    public int hashCode() {
        return 31 * this.myType.hashCode() + (int)(this.myId ^ this.myId >>> 32);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSystemTaskId that = (ExternalSystemTaskId)o;
        return this.myId == that.myId && this.myType == that.myType;
    }

    public String toString() {
        return (Object)((Object)this.myType) + ":" + this.myId;
    }
}

