/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.util.containers.HashMap;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LibraryData
extends AbstractNamedData
implements Named {
    private static final long serialVersionUID = 1L;
    private final Map<LibraryPathType, Set<String>> myPaths = new HashMap();
    private final boolean myUnresolved;

    public LibraryData(@NotNull ProjectSystemId owner, @NotNull String name) {
        this(owner, name, false);
    }

    public LibraryData(@NotNull ProjectSystemId owner, @NotNull String name, boolean unresolved) {
        super(owner, name, name.isEmpty() ? "" : String.format("%s: %s", owner.getReadableName(), name));
        this.myUnresolved = unresolved;
    }

    public boolean isUnresolved() {
        return this.myUnresolved;
    }

    @NotNull
    public Set<String> getPaths(@NotNull LibraryPathType type) {
        Set<String> result = this.myPaths.get((Object)type);
        return result == null ? Collections.emptySet() : result;
    }

    public void addPath(@NotNull LibraryPathType type, @NotNull String path2) {
        Set<String> paths = this.myPaths.get((Object)type);
        if (paths == null) {
            paths = new LinkedHashSet<String>();
            this.myPaths.put(type, paths);
        }
        paths.add(ExternalSystemApiUtil.toCanonicalPath(path2));
    }

    public void forgetAllPaths() {
        this.myPaths.clear();
    }

    @Override
    public int hashCode() {
        int result = this.myPaths.hashCode();
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.myUnresolved ? 0 : 1);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        LibraryData that = (LibraryData)o;
        return super.equals(that) && this.myUnresolved == that.myUnresolved && this.myPaths.equals(that.myPaths);
    }

    public String toString() {
        return String.format("library %s%s", this.getExternalName(), this.myUnresolved ? "(unresolved)" : "");
    }
}

