/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextAttributesKey
implements Comparable<TextAttributesKey> {
    private static final Logger LOG = Logger.getInstance((String)("#" + TextAttributesKey.class.getName()));
    private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();
    private static final ConcurrentMap<String, TextAttributesKey> ourRegistry = ContainerUtil.newConcurrentMap();
    private static final NullableLazyValue<TextAttributeKeyDefaultsProvider> ourDefaultsProvider = new VolatileNullableLazyValue<TextAttributeKeyDefaultsProvider>(){

        @Nullable
        protected TextAttributeKeyDefaultsProvider compute() {
            return ServiceManager.getService(TextAttributeKeyDefaultsProvider.class);
        }
    };
    private final String myExternalName;
    private TextAttributes myDefaultAttributes = NULL_ATTRIBUTES;
    private TextAttributesKey myFallbackAttributeKey;

    private TextAttributesKey(String externalName) {
        this.myExternalName = externalName;
    }

    public TextAttributesKey(@NotNull Element element) {
        this(JDOMExternalizerUtil.readField((Element)element, (String)"myExternalName"));
        Element myDefaultAttributesElement = JDOMExternalizerUtil.getOption((Element)element, (String)"myDefaultAttributes");
        if (myDefaultAttributesElement != null) {
            this.myDefaultAttributes = new TextAttributes(myDefaultAttributesElement);
        }
    }

    @NotNull
    public static TextAttributesKey find(@NotNull @NonNls String externalName) {
        return (TextAttributesKey)ConcurrencyUtil.cacheOrGet(ourRegistry, (Object)externalName, (Object)new TextAttributesKey(externalName));
    }

    public String toString() {
        return this.myExternalName;
    }

    public String getExternalName() {
        return this.myExternalName;
    }

    @Override
    public int compareTo(@NotNull TextAttributesKey key) {
        return this.myExternalName.compareTo(key.myExternalName);
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName) {
        return TextAttributesKey.find(externalName);
    }

    public void writeExternal(Element element) {
        JDOMExternalizerUtil.writeField((Element)element, (String)"myExternalName", (String)this.myExternalName);
        if (this.myDefaultAttributes != NULL_ATTRIBUTES) {
            Element option = JDOMExternalizerUtil.writeOption((Element)element, (String)"myDefaultAttributes");
            this.myDefaultAttributes.writeExternal(option);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextAttributesKey that = (TextAttributesKey)o;
        return this.myExternalName.equals(that.myExternalName);
    }

    public int hashCode() {
        return this.myExternalName.hashCode();
    }

    public TextAttributes getDefaultAttributes() {
        if (this.myDefaultAttributes == NULL_ATTRIBUTES) {
            this.myDefaultAttributes = null;
            TextAttributeKeyDefaultsProvider provider = (TextAttributeKeyDefaultsProvider)ourDefaultsProvider.getValue();
            if (provider != null) {
                this.myDefaultAttributes = provider.getDefaultAttributes(this);
            }
        } else if (this.myDefaultAttributes == null) {
            this.myDefaultAttributes = NULL_ATTRIBUTES;
        }
        return this.myDefaultAttributes;
    }

    @Deprecated
    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName, TextAttributes defaultAttributes) {
        TextAttributesKey key = TextAttributesKey.find(externalName);
        if (key.myDefaultAttributes == null || key.myDefaultAttributes == NULL_ATTRIBUTES) {
            key.myDefaultAttributes = defaultAttributes;
        }
        return key;
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName, TextAttributesKey fallbackAttributeKey) {
        TextAttributesKey key = TextAttributesKey.find(externalName);
        key.setFallbackAttributeKey(fallbackAttributeKey);
        return key;
    }

    public TextAttributesKey getFallbackAttributeKey() {
        return this.myFallbackAttributeKey;
    }

    public void setFallbackAttributeKey(TextAttributesKey fallbackAttributeKey) {
        this.myFallbackAttributeKey = fallbackAttributeKey;
        if (fallbackAttributeKey != null) {
            this.checkDependencies(fallbackAttributeKey, new HashSet<TextAttributesKey>());
        }
    }

    public static void removeTextAttributesKey(@NonNls @NotNull String externalName) {
        if (ourRegistry.containsKey(externalName)) {
            ourRegistry.remove(externalName);
        }
    }

    private void checkDependencies(@Nullable TextAttributesKey key, Set<TextAttributesKey> referencedKeys) {
        if (key != null) {
            if (!referencedKeys.contains(key)) {
                referencedKeys.add(key);
                TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
                if (fallbackKey != null) {
                    this.checkDependencies(fallbackKey, referencedKeys);
                }
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("Cyclic TextAttributesKey dependency found: ");
                this.printDependencyLoop(sb, key);
                this.myFallbackAttributeKey = null;
                LOG.error(sb.toString());
            }
        }
    }

    private void printDependencyLoop(@NotNull StringBuilder stringBuilder, @NotNull TextAttributesKey currNode) {
        stringBuilder.append(currNode.getExternalName()).append("->");
        TextAttributesKey fallbackKey = currNode.getFallbackAttributeKey();
        if (fallbackKey == this) {
            stringBuilder.append(this.getExternalName());
            return;
        }
        this.printDependencyLoop(stringBuilder, fallbackKey);
    }

    public static interface TextAttributeKeyDefaultsProvider {
        public TextAttributes getDefaultAttributes(TextAttributesKey var1);
    }
}

