/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataContextWrapper;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaretSpecificDataContext
extends DataContextWrapper {
    private final Caret myCaret;

    public CaretSpecificDataContext(@NotNull DataContext delegate, @NotNull Caret caret) {
        super(delegate);
        this.myCaret = caret;
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        Object data;
        FileEditorManager fm;
        Project project = (Project)super.getData(CommonDataKeys.PROJECT.getName());
        if (project != null && (fm = FileEditorManager.getInstance(project)) != null && (data = fm.getData(dataId, this.myCaret.getEditor(), this.myCaret)) != null) {
            return data;
        }
        if (CommonDataKeys.CARET.is(dataId)) {
            return this.myCaret;
        }
        return super.getData(dataId);
    }
}

