/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.AirContentRevision;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PathDescription;
import com.intellij.openapi.diff.impl.patch.StaticPathDescription;
import com.intellij.openapi.diff.impl.patch.TextPatchBuilder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.SortByVcsRoots;
import com.intellij.util.BeforeAfter;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaTextPatchBuilder {
    private IdeaTextPatchBuilder() {
    }

    public static List<BeforeAfter<AirContentRevision>> revisionsConvertor(Project project, List<Change> changes) throws VcsException {
        ArrayList<BeforeAfter<AirContentRevision>> result = new ArrayList<BeforeAfter<AirContentRevision>>(changes.size());
        Convertor<Change, FilePath> beforePrefferingConvertor = new Convertor<Change, FilePath>(){

            public FilePath convert(Change o) {
                FilePath before = ChangesUtil.getBeforePath(o);
                return before == null ? ChangesUtil.getAfterPath(o) : before;
            }
        };
        MultiMap<VcsRoot, Change> byRoots = new SortByVcsRoots<Change>(project, beforePrefferingConvertor).sort(changes);
        for (VcsRoot root : byRoots.keySet()) {
            Collection rootChanges = byRoots.get((Object)root);
            if (root.getVcs() == null || root.getVcs().getOutgoingChangesProvider() == null) {
                IdeaTextPatchBuilder.addConvertChanges(rootChanges, result);
                continue;
            }
            VcsOutgoingChangesProvider provider = root.getVcs().getOutgoingChangesProvider();
            Collection<Change> basedOnLocal = provider.filterLocalChangesBasedOnLocalCommits(rootChanges, root.getPath());
            rootChanges.removeAll(basedOnLocal);
            IdeaTextPatchBuilder.addConvertChanges(rootChanges, result);
            for (Change change : basedOnLocal) {
                result.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevision(change.getBeforeRevision(), provider), (Object)IdeaTextPatchBuilder.convertRevision(change.getAfterRevision(), provider)));
            }
        }
        return result;
    }

    private static void addConvertChanges(Collection<Change> changes, List<BeforeAfter<AirContentRevision>> result) {
        for (Change change : changes) {
            result.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevisionToAir(change.getBeforeRevision()), (Object)IdeaTextPatchBuilder.convertRevisionToAir(change.getAfterRevision())));
        }
    }

    @NotNull
    public static List<FilePatch> buildPatch(Project project, Collection<Change> changes, String basePath, boolean reversePatch) throws VcsException {
        return IdeaTextPatchBuilder.buildPatch(project, changes, basePath, reversePatch, false);
    }

    @NotNull
    public static List<FilePatch> buildPatch(Project project, Collection<Change> changes, String basePath, boolean reversePatch, boolean includeBaseText) throws VcsException {
        ArrayList<BeforeAfter<AirContentRevision>> revisions;
        if (project != null) {
            revisions = IdeaTextPatchBuilder.revisionsConvertor(project, new ArrayList<Change>(changes));
        } else {
            revisions = new ArrayList(changes.size());
            for (Change change : changes) {
                revisions.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevisionToAir(change.getBeforeRevision()), (Object)IdeaTextPatchBuilder.convertRevisionToAir(change.getAfterRevision())));
            }
        }
        return TextPatchBuilder.buildPatch(revisions, basePath, reversePatch, SystemInfo.isFileSystemCaseSensitive, new Runnable(){

            @Override
            public void run() {
                ProgressManager.checkCanceled();
            }
        }, includeBaseText);
    }

    @Nullable
    private static AirContentRevision convertRevisionToAir(ContentRevision cr) {
        return IdeaTextPatchBuilder.convertRevisionToAir(cr, null);
    }

    @Nullable
    private static AirContentRevision convertRevisionToAir(final ContentRevision cr, final Long ts) {
        if (cr == null) {
            return null;
        }
        final FilePath fp = cr.getFile();
        final StaticPathDescription description = new StaticPathDescription(fp.isDirectory(), ts == null ? fp.getIOFile().lastModified() : ts.longValue(), fp.getPath());
        if (cr instanceof BinaryContentRevision) {
            return new AirContentRevision(){

                @Override
                public boolean isBinary() {
                    return true;
                }

                @Override
                public String getContentAsString() {
                    throw new IllegalStateException();
                }

                @Override
                public byte[] getContentAsBytes() throws VcsException {
                    return ((BinaryContentRevision)cr).getBinaryContent();
                }

                @Override
                public String getRevisionNumber() {
                    return ts != null ? null : cr.getRevisionNumber().asString();
                }

                @Override
                @NotNull
                public PathDescription getPath() {
                    return description;
                }

                @Override
                public Charset getCharset() {
                    return null;
                }
            };
        }
        return new AirContentRevision(){

            @Override
            public boolean isBinary() {
                return false;
            }

            @Override
            public String getContentAsString() throws VcsException {
                return cr.getContent();
            }

            @Override
            public byte[] getContentAsBytes() throws VcsException {
                throw new IllegalStateException();
            }

            @Override
            public String getRevisionNumber() {
                return ts != null ? null : cr.getRevisionNumber().asString();
            }

            @Override
            @NotNull
            public PathDescription getPath() {
                return description;
            }

            @Override
            public Charset getCharset() {
                return fp.getCharset();
            }
        };
    }

    @Nullable
    private static AirContentRevision convertRevision(@Nullable ContentRevision cr, VcsOutgoingChangesProvider provider) {
        if (cr == null) {
            return null;
        }
        Date date = provider.getRevisionDate(cr.getRevisionNumber(), cr.getFile());
        Long ts = date == null ? null : Long.valueOf(date.getTime());
        return IdeaTextPatchBuilder.convertRevisionToAir(cr, ts);
    }
}

