/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jetbrains.annotations.NotNull;

abstract class DocumentsSynchronizer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.DocumentsSynchonizer");
    private Document myOriginal = null;
    private Document myCopy = null;
    private final Project myProject;
    private volatile boolean myDuringModification = false;
    private int myAssignedCount = 0;
    private final DocumentAdapter myOriginalListener = new DocumentAdapter(){

        @Override
        public void documentChanged(DocumentEvent e) {
            if (DocumentsSynchronizer.this.myDuringModification) {
                return;
            }
            DocumentsSynchronizer.this.onOriginalChanged(e, DocumentsSynchronizer.this.getCopy());
        }
    };
    private final DocumentAdapter myCopyListener = new DocumentAdapter(){

        @Override
        public void documentChanged(DocumentEvent e) {
            if (DocumentsSynchronizer.this.myDuringModification) {
                return;
            }
            DocumentsSynchronizer.this.onCopyChanged(e, DocumentsSynchronizer.this.getOriginal());
        }
    };
    private final PropertyChangeListener myROListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("writable".equals(evt.getPropertyName())) {
                DocumentsSynchronizer.this.getCopy().setReadOnly(!DocumentsSynchronizer.this.getOriginal().isWritable());
            }
        }
    };

    protected DocumentsSynchronizer(Project project) {
        this.myProject = project;
    }

    protected abstract void onCopyChanged(@NotNull DocumentEvent var1, @NotNull Document var2);

    protected abstract void onOriginalChanged(@NotNull DocumentEvent var1, @NotNull Document var2);

    protected abstract void beforeListenersAttached(@NotNull Document var1, @NotNull Document var2);

    protected abstract Document createOriginal();

    @NotNull
    protected abstract Document createCopy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceString(final @NotNull Document document, final int startOffset, final int endOffset, final @NotNull String newText) {
        LOG.assertTrue(!this.myDuringModification);
        try {
            this.myDuringModification = true;
            CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                @Override
                public void run() {
                    LOG.assertTrue(endOffset <= document.getTextLength());
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            document.replaceString(startOffset, endOffset, newText);
                        }
                    });
                }
            }, DiffBundle.message("save.merge.result.command.name", new Object[0]), document);
        }
        finally {
            this.myDuringModification = false;
        }
    }

    public void listenDocuments(boolean startListen) {
        int prevAssignedCount = this.myAssignedCount++;
        if (!startListen) {
            --this.myAssignedCount;
        }
        LOG.assertTrue(this.myAssignedCount >= 0);
        if (prevAssignedCount == 0 && this.myAssignedCount > 0) {
            this.startListen();
        }
        if (this.myAssignedCount == 0 && prevAssignedCount > 0) {
            this.stopListen();
        }
    }

    private void startListen() {
        Document original = this.getOriginal();
        Document copy = this.getCopy();
        if (original == null) {
            return;
        }
        this.beforeListenersAttached(original, copy);
        original.addDocumentListener(this.myOriginalListener);
        copy.addDocumentListener(this.myCopyListener);
        original.addPropertyChangeListener(this.myROListener);
    }

    private void stopListen() {
        if (this.myOriginal != null) {
            this.myOriginal.removeDocumentListener(this.myOriginalListener);
            this.myOriginal.removePropertyChangeListener(this.myROListener);
        }
        if (this.myCopy != null) {
            this.myCopy.removeDocumentListener(this.myCopyListener);
        }
        this.myOriginal = null;
        this.myCopy = null;
    }

    public Document getOriginal() {
        if (this.myOriginal == null) {
            this.myOriginal = this.createOriginal();
        }
        return this.myOriginal;
    }

    @NotNull
    public Document getCopy() {
        if (this.myCopy == null) {
            this.myCopy = this.createCopy();
        }
        return this.myCopy;
    }
}

