/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class StateSplitterEx
implements StateSplitter {
    @Override
    public abstract List<Pair<Element, String>> splitState(@NotNull Element var1);

    public void mergeStateInto(@NotNull Element target, @NotNull Element subState) {
        target.addContent(subState);
    }

    @Override
    public final void mergeStatesInto(Element target, Element[] elements) {
        throw new IllegalStateException();
    }

    @NotNull
    protected static List<Pair<Element, String>> splitState(@NotNull Element state, @NotNull String attributeName) {
        UniqueNameGenerator generator = new UniqueNameGenerator();
        SmartList result = new SmartList();
        for (Element subState : state.getChildren()) {
            result.add(StateSplitterEx.createItem(generator, subState, attributeName));
        }
        return result;
    }

    @NotNull
    protected static Pair<Element, String> createItem(@NotNull UniqueNameGenerator generator, @NotNull Element element, @NotNull String attributeName) {
        return StateSplitterEx.createItem(element.getAttributeValue(attributeName), generator, element);
    }

    @NotNull
    protected static Pair<Element, String> createItem(@NotNull String fileName, @NotNull UniqueNameGenerator generator, @NotNull Element element) {
        return Pair.create((Object)element, (Object)(generator.generateUniqueName(FileUtil.sanitizeFileName((String)fileName)) + ".xml"));
    }

    protected static void mergeStateInto(@NotNull Element target, @NotNull Element subState, @NotNull String subStateName) {
        if (subState.getName().equals(subStateName)) {
            target.addContent(subState);
        } else {
            Iterator iterator = subState.getChildren().iterator();
            while (iterator.hasNext()) {
                Element configuration = (Element)iterator.next();
                iterator.remove();
                target.addContent(configuration);
            }
            iterator = subState.getAttributes().iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                iterator.remove();
                target.setAttribute(attribute);
            }
        }
    }
}

