/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;

public abstract class WriteAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.WriteAction");

    @Override
    @NotNull
    public RunResult<T> execute() {
        final RunResult result = new RunResult(this);
        final Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed()) {
            result.run();
            return result;
        }
        boolean dispatchThread = application.isDispatchThread();
        if (!dispatchThread && application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
        }
        application.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AccessToken token = application.acquireWriteActionLock(WriteAction.this.getClass());
                try {
                    result.run();
                }
                finally {
                    token.finish();
                }
            }
        }, ModalityState.defaultModalityState());
        result.throwException();
        return result;
    }

    @NotNull
    public static AccessToken start() {
        Class aClass = (Class)ObjectUtils.notNull((Object)ReflectionUtil.getGrandCallerClass(), WriteAction.class);
        return WriteAction.start(aClass);
    }

    @NotNull
    public static AccessToken start(@NotNull Class clazz) {
        return ApplicationManager.getApplication().acquireWriteActionLock(clazz);
    }
}

