/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingDescriptor {
    public static final FoldingDescriptor[] EMPTY = new FoldingDescriptor[0];
    private final ASTNode myElement;
    private final TextRange myRange;
    @Nullable
    private final FoldingGroup myGroup;
    private final Set<Object> myDependencies;
    private final boolean myNeverExpands;
    private boolean myCanBeRemovedWhenCollapsed;

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range) {
        this(node, range, null);
    }

    public FoldingDescriptor(@NotNull PsiElement element, @NotNull TextRange range) {
        this((ASTNode)ObjectUtils.assertNotNull((Object)element.getNode()), range, null);
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group) {
        this(node, range, group, Collections.emptySet());
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group, Set<Object> dependencies) {
        this(node, range, group, dependencies, false);
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group, Set<Object> dependencies, boolean neverExpands) {
        assert (range.getLength() > 0) : range + ", text: " + node.getText() + ", language = " + (Object)((Object)node.getPsi().getLanguage());
        this.myElement = node;
        this.myRange = range;
        this.myGroup = group;
        this.myDependencies = dependencies;
        assert (!this.myDependencies.contains(null));
        this.myNeverExpands = neverExpands;
    }

    @NotNull
    public ASTNode getElement() {
        return this.myElement;
    }

    @NotNull
    public TextRange getRange() {
        return this.myRange;
    }

    @Nullable
    public FoldingGroup getGroup() {
        return this.myGroup;
    }

    @Nullable
    public String getPlaceholderText() {
        PsiElement psiElement = this.myElement.getPsi();
        if (psiElement == null) {
            return null;
        }
        Language lang = psiElement.getLanguage();
        FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(lang);
        if (foldingBuilder != null) {
            return foldingBuilder instanceof FoldingBuilderEx ? ((FoldingBuilderEx)foldingBuilder).getPlaceholderText(this.myElement, this.myRange) : foldingBuilder.getPlaceholderText(this.myElement);
        }
        return null;
    }

    @NotNull
    public Set<Object> getDependencies() {
        return this.myDependencies;
    }

    public boolean isNonExpandable() {
        return this.myNeverExpands;
    }

    public boolean canBeRemovedWhenCollapsed() {
        return this.myCanBeRemovedWhenCollapsed;
    }

    public void setCanBeRemovedWhenCollapsed(boolean canBeRemovedWhenCollapsed) {
        this.myCanBeRemovedWhenCollapsed = canBeRemovedWhenCollapsed;
    }

    public String toString() {
        return this.myRange + " for AST: " + this.myElement;
    }
}

