/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageExtension<T>
extends KeyedExtensionCollector<T, Language> {
    private final T myDefaultImplementation;
    private final Key<T> IN_LANGUAGE_CACHE;

    public LanguageExtension(@NonNls String epName) {
        this(epName, null);
    }

    public LanguageExtension(@NonNls String epName, @Nullable T defaultImplementation) {
        super(epName);
        this.myDefaultImplementation = defaultImplementation;
        this.IN_LANGUAGE_CACHE = Key.create((String)("EXTENSIONS_IN_LANGUAGE_" + epName));
    }

    @Override
    @NotNull
    protected String keyToString(@NotNull Language key) {
        return key.getID();
    }

    public T forLanguage(@NotNull Language l) {
        Language base;
        Object cached = l.getUserData(this.IN_LANGUAGE_CACHE);
        if (cached != null) {
            return (T)cached;
        }
        List extensions = this.forKey(l);
        Object result = extensions.isEmpty() ? ((base = l.getBaseLanguage()) == null ? this.myDefaultImplementation : this.forLanguage(base)) : extensions.get(0);
        if (result == null) {
            return null;
        }
        result = l.putUserDataIfAbsent(this.IN_LANGUAGE_CACHE, result);
        return result;
    }

    @NotNull
    public List<T> allForLanguage(@NotNull Language l) {
        Language base;
        List list = this.forKey(l);
        if (list.isEmpty() && (base = l.getBaseLanguage()) != null) {
            return this.allForLanguage(base);
        }
        return list;
    }

    @NotNull
    public List<T> allForLanguageOrAny(@NotNull Language l) {
        List<T> providers = this.allForLanguage(l);
        if (l == Language.ANY) {
            return providers;
        }
        return ContainerUtil.concat(providers, this.allForLanguage(Language.ANY));
    }

    protected T getDefaultImplementation() {
        return this.myDefaultImplementation;
    }

    @NotNull
    protected Key<T> getLanguageCache() {
        return this.IN_LANGUAGE_CACHE;
    }
}

