/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebBrowserUrlProvider {
    public static final ExtensionPointName<WebBrowserUrlProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.webBrowserUrlProvider");

    public boolean canHandleElement(@NotNull OpenInBrowserRequest request) {
        try {
            Collection<Url> urls = this.getUrls(request);
            if (!urls.isEmpty()) {
                request.setResult(urls);
                return true;
            }
        }
        catch (BrowserException browserException) {
            // empty catch block
        }
        return false;
    }

    @Nullable
    protected Url getUrl(@NotNull OpenInBrowserRequest request, @NotNull VirtualFile file) throws BrowserException {
        return null;
    }

    @NotNull
    public Collection<Url> getUrls(@NotNull OpenInBrowserRequest request) throws BrowserException {
        return ContainerUtil.createMaybeSingletonList((Object)this.getUrl(request, request.getVirtualFile()));
    }

    @Deprecated
    @Nullable
    public String getOpenInBrowserActionDescription(@NotNull PsiFile file) {
        return null;
    }

    public static class BrowserException
    extends Exception {
        public BrowserException(String message) {
            super(message);
        }
    }
}

