/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Url;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenInBrowserRequest {
    private Collection<Url> result;
    protected PsiFile file;
    private boolean appendAccessToken = true;

    public OpenInBrowserRequest(@NotNull PsiFile file) {
        this.file = file;
    }

    public OpenInBrowserRequest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static OpenInBrowserRequest create(final @NotNull PsiElement element) {
        PsiFile psiFile;
        AccessToken token = ReadAction.start();
        try {
            PsiFile psiFile2 = psiFile = element.isValid() ? element.getContainingFile() : null;
            if (psiFile == null || psiFile.getVirtualFile() == null) {
                OpenInBrowserRequest openInBrowserRequest = null;
                return openInBrowserRequest;
            }
        }
        finally {
            token.finish();
        }
        return new OpenInBrowserRequest(psiFile){

            @Override
            @NotNull
            public PsiElement getElement() {
                return element;
            }
        };
    }

    @NotNull
    public PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.file.getVirtualFile();
    }

    @NotNull
    public Project getProject() {
        return this.file.getProject();
    }

    @NotNull
    public abstract PsiElement getElement();

    public void setResult(@NotNull Collection<Url> result) {
        this.result = result;
    }

    @Nullable
    public Collection<Url> getResult() {
        return this.result;
    }

    public boolean isAppendAccessToken() {
        return this.appendAccessToken;
    }

    public void setAppendAccessToken(boolean value) {
        this.appendAccessToken = value;
    }
}

