/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiActivity
implements ComparableObject {
    private final List<String> myElements = new ArrayList<String>();

    public UiActivity(String ... elements) {
        this(elements, (String[])null);
    }

    protected UiActivity(@NotNull String[] elements1, @Nullable String[] elements2) {
        this.myElements.addAll(Arrays.asList(elements1));
        if (elements2 != null) {
            this.myElements.addAll(Arrays.asList(elements2));
        }
    }

    @NotNull
    public Object[] getEqualityObjects() {
        return new Object[]{this.myElements};
    }

    public String toString() {
        return "UiActivity: " + this.myElements;
    }

    public int hashCode() {
        return ComparableObjectCheck.hashCode((ComparableObject)this, (int)super.hashCode());
    }

    public boolean equals(Object obj) {
        return ComparableObjectCheck.equals((ComparableObject)this, (Object)obj);
    }

    public final boolean isSameOrGeneralFor(UiActivity other) {
        if (this.myElements.size() > other.myElements.size()) {
            return false;
        }
        for (int i = 0; i < this.myElements.size(); ++i) {
            if (this.myElements.get(i).equals(other.myElements.get(i))) continue;
            return false;
        }
        return true;
    }

    public static class Progress
    extends UiActivity {
        public Progress(String type, String id) {
            super("progress", type, id);
        }

        public static class Modal
        extends Progress {
            public Modal(String id) {
                super("modal", id);
            }
        }
    }

    public static class AsyncBgOperation
    extends UiActivity {
        public AsyncBgOperation(String operationName) {
            super("asyncBgOperation", operationName);
        }
    }

    public static class Focus
    extends UiActivity {
        public Focus(String ... subOperation) {
            super(new String[]{"focus"}, subOperation);
        }
    }
}

