/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.util.ProcessingContext;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FileContentPattern
extends ObjectPattern<FileContent, FileContentPattern> {
    private FileContentPattern() {
        super(FileContent.class);
    }

    public static FileContentPattern fileContent() {
        return new FileContentPattern();
    }

    public FileContentPattern withName(final @NotNull String name) {
        return (FileContentPattern)this.with(new PatternCondition<FileContent>("withName"){

            @Override
            public boolean accepts(@NotNull FileContent fileContent, ProcessingContext context) {
                return name.equals(fileContent.getFileName());
            }
        });
    }

    public FileContentPattern withName(final StringPattern namePattern) {
        return (FileContentPattern)this.with(new PatternCondition<FileContent>("withName"){

            @Override
            public boolean accepts(@NotNull FileContent fileContent, ProcessingContext context) {
                return namePattern.accepts(fileContent.getFileName());
            }
        });
    }

    public FileContentPattern inDirectory(final @NotNull String name) {
        return (FileContentPattern)this.with(new PatternCondition<FileContent>("inDirectory"){

            @Override
            public boolean accepts(@NotNull FileContent fileContent, ProcessingContext context) {
                return name.equals(fileContent.getFile().getParent().getName());
            }
        });
    }

    public FileContentPattern xmlWithRootTag(final @NotNull String rootTag) {
        return (FileContentPattern)this.with(new PatternCondition<FileContent>("withRootTag"){

            @Override
            public boolean accepts(@NotNull FileContent fileContent, ProcessingContext context) {
                try {
                    return rootTag.equals(FileContentPattern.parseHeaderWithException(fileContent).getRootTagLocalName());
                }
                catch (IOException e) {
                    return false;
                }
            }
        });
    }

    public FileContentPattern xmlWithRootTagNamespace(String namespace) {
        return this.xmlWithRootTagNamespace((ElementPattern<String>)StandardPatterns.string().equalTo(namespace));
    }

    public FileContentPattern xmlWithRootTagNamespace(final ElementPattern<String> namespacePattern) {
        return (FileContentPattern)this.with(new PatternCondition<FileContent>("xmlWithRootTagNamespace"){

            @Override
            public boolean accepts(@NotNull FileContent fileContent, ProcessingContext context) {
                try {
                    String rootTagNamespace = FileContentPattern.parseHeaderWithException(fileContent).getRootTagNamespace();
                    return rootTagNamespace != null && namespacePattern.accepts(rootTagNamespace, context);
                }
                catch (IOException e) {
                    return false;
                }
            }
        });
    }

    @NotNull
    private static XmlFileHeader parseHeaderWithException(FileContent fileContent) throws IOException {
        return NanoXmlUtil.parseHeaderWithException(CharArrayUtil.readerFromCharSequence((CharSequence)fileContent.getContentAsText()));
    }
}

