/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.actions;

import com.intellij.execution.ui.actions.BaseViewAction;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.ui.content.Content;
import org.jetbrains.annotations.NotNull;

public class AbstractFocusOnAction
extends BaseViewAction
implements Toggleable {
    @NotNull
    private final String myCondition;

    public AbstractFocusOnAction(@NotNull String condition) {
        this.myCondition = condition;
    }

    @Override
    protected void update(AnActionEvent e, ViewContext context, Content[] content) {
        boolean visible = content.length == 1;
        e.getPresentation().setVisible(visible);
        if (visible) {
            e.getPresentation().putClientProperty("selected", this.isToFocus(context, content));
        }
    }

    private boolean isToFocus(ViewContext context, Content[] content) {
        return context.getRunnerLayoutUi().getOptions().isToFocus(content[0], this.myCondition);
    }

    @Override
    protected void actionPerformed(AnActionEvent e, ViewContext context, Content[] content) {
        boolean toFocus = this.isToFocus(context, content);
        context.getRunnerLayoutUi().getOptions().setToFocus(toFocus ? null : content[0], this.myCondition);
    }
}

