/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.BaseProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class AsyncGenericProgramRunner<Settings extends RunnerSettings>
extends BaseProgramRunner<Settings> {
    @Override
    protected final void execute(final @NotNull ExecutionEnvironment environment, final @Nullable ProgramRunner.Callback callback, final @NotNull RunProfileState state) throws ExecutionException {
        this.prepare(environment, state).done(new Consumer<RunProfileStarter>(){

            public void consume(final @Nullable RunProfileStarter result) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!environment.getProject().isDisposed()) {
                            AsyncGenericProgramRunner.startRunProfile(environment, state, callback, result);
                        }
                    }
                });
            }
        });
    }

    @NotNull
    protected abstract Promise<RunProfileStarter> prepare(@NotNull ExecutionEnvironment var1, @NotNull RunProfileState var2) throws ExecutionException;

    private static void startRunProfile(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, final @Nullable ProgramRunner.Callback callback, final @Nullable RunProfileStarter starter) {
        ExecutionManager.getInstance(environment.getProject()).startRunProfile(new RunProfileStarter(){

            @Override
            public RunContentDescriptor execute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
                return BaseProgramRunner.postProcess(environment, starter == null ? null : starter.execute(state, environment), callback);
            }
        }, state, environment);
    }
}

