/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RuntimeConfigurationProducer
implements Comparable,
Cloneable {
    public static final ExtensionPointName<RuntimeConfigurationProducer> RUNTIME_CONFIGURATION_PRODUCER = ExtensionPointName.create((String)"com.intellij.configurationProducer");
    public static final Comparator<RuntimeConfigurationProducer> COMPARATOR = new ProducerComparator();
    protected static final int PREFERED = -1;
    private final ConfigurationFactory myConfigurationFactory;
    private RunnerAndConfigurationSettings myConfiguration;
    protected boolean isClone;

    public RuntimeConfigurationProducer(ConfigurationType configurationType) {
        this(configurationType.getConfigurationFactories()[0]);
    }

    protected RuntimeConfigurationProducer(ConfigurationFactory configurationFactory) {
        this.myConfigurationFactory = configurationFactory;
    }

    public RuntimeConfigurationProducer createProducer(Location location, ConfigurationContext context) {
        PsiElement psiElement;
        Location<PsiElement> _location;
        RuntimeConfigurationProducer result = this.clone();
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = result.myConfiguration = location != null ? result.createConfigurationByElement(location, context) : null;
        if (result.myConfiguration != null && (_location = PsiLocation.fromPsiElement(psiElement = result.getSourceElement(), location != null ? location.getModule() : null)) != null) {
            ConfigurationType type;
            RunManager runManager = RunManager.getInstance(context.getProject());
            List<RunnerAndConfigurationSettings> configurations = runManager.getConfigurationSettingsList(type = result.myConfiguration.getType());
            RunnerAndConfigurationSettings configuration = result.findExistingByElement(_location, configurations, context);
            if (configuration != null) {
                result.myConfiguration = configuration;
            } else {
                ArrayList<String> currentNames = new ArrayList<String>();
                for (RunnerAndConfigurationSettings configurationSettings : configurations) {
                    currentNames.add(configurationSettings.getName());
                }
                result.myConfiguration.setName(RunManager.suggestUniqueName(result.myConfiguration.getName(), currentNames));
            }
        }
        return result;
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfiguration(@NotNull Location location, ConfigurationContext context) {
        assert (this.isClone);
        RunManager runManager = RunManager.getInstance(location.getProject());
        List<RunnerAndConfigurationSettings> configurations = runManager.getConfigurationSettingsList(this.getConfigurationType());
        return this.findExistingByElement(location, configurations, context);
    }

    public abstract PsiElement getSourceElement();

    public RunnerAndConfigurationSettings getConfiguration() {
        assert (this.isClone);
        return this.myConfiguration;
    }

    public void setConfiguration(RunnerAndConfigurationSettings configuration) {
        assert (this.isClone);
        this.myConfiguration = configuration;
    }

    @Nullable
    protected abstract RunnerAndConfigurationSettings createConfigurationByElement(Location var1, ConfigurationContext var2);

    @Nullable
    protected RunnerAndConfigurationSettings findExistingByElement(Location location, @NotNull List<RunnerAndConfigurationSettings> existingConfigurations, ConfigurationContext context) {
        assert (this.isClone);
        return null;
    }

    public RuntimeConfigurationProducer clone() {
        assert (!this.isClone);
        try {
            RuntimeConfigurationProducer clone = (RuntimeConfigurationProducer)super.clone();
            clone.isClone = true;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected RunnerAndConfigurationSettings cloneTemplateConfiguration(Project project, @Nullable ConfigurationContext context) {
        RunConfiguration original;
        if (context != null && (original = context.getOriginalConfiguration(this.myConfigurationFactory.getType())) != null) {
            RunConfiguration c = original instanceof DelegatingRuntimeConfiguration ? ((DelegatingRuntimeConfiguration)original).getPeer() : original;
            return RunManager.getInstance(project).createConfiguration(c.clone(), this.myConfigurationFactory);
        }
        return RunManager.getInstance(project).createRunConfiguration("", this.myConfigurationFactory);
    }

    protected ConfigurationFactory getConfigurationFactory() {
        return this.myConfigurationFactory;
    }

    public ConfigurationType getConfigurationType() {
        return this.myConfigurationFactory.getType();
    }

    public void perform(ConfigurationContext context, Runnable performRunnable) {
        performRunnable.run();
    }

    public static <T extends RuntimeConfigurationProducer> T getInstance(Class<T> aClass) {
        RuntimeConfigurationProducer[] configurationProducers;
        for (RuntimeConfigurationProducer configurationProducer : configurationProducers = (RuntimeConfigurationProducer[])Extensions.getExtensions(RUNTIME_CONFIGURATION_PRODUCER)) {
            if (configurationProducer.getClass() != aClass) continue;
            return (T)configurationProducer;
        }
        return null;
    }

    public static class DelegatingRuntimeConfiguration<T extends LocatableConfiguration>
    extends LocatableConfigurationBase
    implements ModuleRunConfiguration {
        private final T myConfig;

        public DelegatingRuntimeConfiguration(T config) {
            super(config.getProject(), config.getFactory(), config.getName());
            this.myConfig = config;
        }

        @Override
        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            return this.myConfig.getConfigurationEditor();
        }

        @Override
        public DelegatingRuntimeConfiguration<T> clone() {
            return new DelegatingRuntimeConfiguration<LocatableConfiguration>((LocatableConfiguration)this.myConfig.clone());
        }

        @Override
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
            return this.myConfig.getState(executor, env);
        }

        @Override
        public void checkConfiguration() throws RuntimeConfigurationException {
            this.myConfig.checkConfiguration();
        }

        @Override
        public String suggestedName() {
            return this.myConfig.suggestedName();
        }

        @Override
        public void readExternal(Element element) throws InvalidDataException {
            this.myConfig.readExternal(element);
        }

        @Override
        public void writeExternal(Element element) throws WriteExternalException {
            this.myConfig.writeExternal(element);
        }

        public T getPeer() {
            return this.myConfig;
        }

        @Override
        @NotNull
        public Module[] getModules() {
            return Module.EMPTY_ARRAY;
        }
    }

    private static class ProducerComparator
    implements Comparator<RuntimeConfigurationProducer> {
        private ProducerComparator() {
        }

        @Override
        public int compare(RuntimeConfigurationProducer producer1, RuntimeConfigurationProducer producer2) {
            PsiElement psiElement2;
            PsiElement psiElement1 = producer1.getSourceElement();
            if (ProducerComparator.doesContain(psiElement1, psiElement2 = producer2.getSourceElement())) {
                return 1;
            }
            if (ProducerComparator.doesContain(psiElement2, psiElement1)) {
                return -1;
            }
            return producer1.compareTo(producer2);
        }

        private static boolean doesContain(PsiElement container, PsiElement element) {
            while ((element = element.getParent()) != null) {
                if (!container.equals(element)) continue;
                return true;
            }
            return false;
        }
    }
}

