/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="module")
public class RunConfigurationModule
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(RunConfigurationModule.class);
    @NonNls
    private static final String ELEMENT = "module";
    @NonNls
    private static final String ATTRIBUTE = "name";
    private Module myModule = null;
    @Attribute(value="name")
    private String myModuleName;
    private final Project myProject;

    public RunConfigurationModule(@NotNull Project project) {
        this.myProject = project;
    }

    public void readExternal(@NotNull Element element) {
        List modules = element.getChildren(ELEMENT);
        if (!modules.isEmpty()) {
            String moduleName;
            if (modules.size() > 1) {
                LOG.warn("Module serialized more than one time");
            }
            if (!StringUtil.isEmpty((String)(moduleName = ((Element)modules.get(0)).getAttributeValue(ATTRIBUTE)))) {
                this.myModuleName = moduleName;
            }
        }
    }

    public void writeExternal(@NotNull Element parent) {
        Element prev = parent.getChild(ELEMENT);
        if (prev == null) {
            prev = new Element(ELEMENT);
            parent.addContent(prev);
        }
        prev.setAttribute(ATTRIBUTE, this.getModuleName());
    }

    public void init() {
        Module[] modules;
        if (StringUtil.isEmptyOrSpaces((String)this.getModuleName()) && (modules = this.getModuleManager().getModules()).length > 0) {
            this.setModule(modules[0]);
        }
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Transient
    @Nullable
    public Module getModule() {
        if (this.myModuleName != null) {
            this.myModule = this.findModule(this.myModuleName);
        }
        if (this.myModule != null && this.myModule.isDisposed()) {
            this.myModule = null;
        }
        return this.myModule;
    }

    @Nullable
    public Module findModule(final String moduleName) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Module>(){

            @Nullable
            public Module compute() {
                return RunConfigurationModule.this.getModuleManager().findModuleByName(moduleName);
            }
        });
    }

    public void setModule(Module module) {
        this.myModule = module;
        this.myModuleName = module != null ? module.getName() : null;
    }

    public String getModuleName() {
        return StringUtil.notNullize((String)this.myModuleName);
    }

    private ModuleManager getModuleManager() {
        return ModuleManager.getInstance(this.myProject);
    }

    public void checkForWarning() throws RuntimeConfigurationException {
        Module module = this.getModule();
        if (module != null) {
            if (ModuleRootManager.getInstance(module).getSdk() == null) {
                throw new RuntimeConfigurationWarning(ExecutionBundle.message("no.jdk.specified.for.module.warning.text", module.getName()));
            }
        } else {
            if (this.myModuleName != null) {
                throw new RuntimeConfigurationError(ExecutionBundle.message("module.doesn.t.exist.in.project.error.text", this.myModuleName));
            }
            throw new RuntimeConfigurationError(ExecutionBundle.message("module.not.specified.error.text", new Object[0]));
        }
    }
}

