/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaCommandLineStateUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public abstract class JavaCommandLineState
extends CommandLineState
implements JavaCommandLine {
    private JavaParameters myParams;

    protected JavaCommandLineState(@NotNull ExecutionEnvironment environment) {
        super(environment);
    }

    @Override
    public JavaParameters getJavaParameters() throws ExecutionException {
        if (this.myParams == null) {
            this.myParams = this.createJavaParameters();
        }
        return this.myParams;
    }

    public void clear() {
        this.myParams = null;
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        return JavaCommandLineStateUtil.startProcess(this.createCommandLine(), this.ansiColoringEnabled());
    }

    protected boolean ansiColoringEnabled() {
        return true;
    }

    protected abstract JavaParameters createJavaParameters() throws ExecutionException;

    protected GeneralCommandLine createCommandLine() throws ExecutionException {
        Project project = this.getEnvironment().getProject();
        return CommandLineBuilder.createFromJavaParameters(this.getJavaParameters(), project, true);
    }

    public boolean shouldAddJavaProgramRunnerActions() {
        return true;
    }
}

