/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.extensions.Extensions;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ConfigurationTypeUtil {
    private ConfigurationTypeUtil() {
    }

    @NotNull
    public static <T extends ConfigurationType> T findConfigurationType(@NotNull Class<T> configurationTypeClass) {
        Object[] types;
        for (ConfigurationType configurationType : types = (ConfigurationType[])Extensions.getExtensions(ConfigurationType.CONFIGURATION_TYPE_EP)) {
            if (!configurationTypeClass.isInstance(configurationType)) continue;
            return (T)configurationType;
        }
        throw new AssertionError((Object)(Arrays.toString(types) + " loader: " + configurationTypeClass.getClassLoader() + ", " + configurationTypeClass));
    }

    public static boolean equals(@NotNull ConfigurationType type1, @NotNull ConfigurationType type2) {
        return type1.getId().equals(type2.getId());
    }

    public static ConfigurationType findConfigurationType(String configurationId) {
        ConfigurationType[] types;
        for (ConfigurationType type : types = (ConfigurationType[])Extensions.getExtensions(ConfigurationType.CONFIGURATION_TYPE_EP)) {
            if (!type.getId().equals(configurationId)) continue;
            return type;
        }
        return null;
    }
}

