/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExecutionTargetManager {
    public static final Topic<ExecutionTargetListener> TOPIC = Topic.create((String)"ExecutionTarget topic", ExecutionTargetListener.class);

    @NotNull
    public static ExecutionTargetManager getInstance(@NotNull Project project) {
        return ServiceManager.getService(project, ExecutionTargetManager.class);
    }

    @NotNull
    public static ExecutionTarget getActiveTarget(@NotNull Project project) {
        return ExecutionTargetManager.getInstance(project).getActiveTarget();
    }

    public static void setActiveTarget(@NotNull Project project, @NotNull ExecutionTarget target) {
        ExecutionTargetManager.getInstance(project).setActiveTarget(target);
    }

    @NotNull
    public static List<ExecutionTarget> getTargetsFor(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings) {
        return ExecutionTargetManager.getInstance(project).getTargetsFor(settings);
    }

    @NotNull
    public static List<ExecutionTarget> getTargetsToChooseFor(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings) {
        List<ExecutionTarget> result = ExecutionTargetManager.getInstance(project).getTargetsFor(settings);
        if (result.size() == 1 && DefaultExecutionTarget.INSTANCE.equals(result.get(0))) {
            return Collections.emptyList();
        }
        return result;
    }

    public static boolean canRun(@Nullable RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget target) {
        return settings != null && target != null && settings.canRunOn(target) && target.canRun(settings);
    }

    public static boolean canRun(@NotNull ExecutionEnvironment environment) {
        return ExecutionTargetManager.canRun(environment.getRunnerAndConfigurationSettings(), environment.getExecutionTarget());
    }

    public static void update(@NotNull Project project) {
        ExecutionTargetManager.getInstance(project).update();
    }

    @NotNull
    public abstract ExecutionTarget getActiveTarget();

    public abstract void setActiveTarget(@NotNull ExecutionTarget var1);

    @NotNull
    public abstract List<ExecutionTarget> getTargetsFor(@Nullable RunnerAndConfigurationSettings var1);

    public abstract void update();
}

