/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultExecutionResult
implements ExecutionResult {
    private final ExecutionConsole myConsole;
    private final ProcessHandler myProcessHandler;
    private AnAction[] myActions;
    @NotNull
    private AnAction[] myRestartActions = AnAction.EMPTY_ARRAY;
    private final List<AnAction> myStopActions = new ArrayList<AnAction>();

    public DefaultExecutionResult() {
        this.myConsole = null;
        this.myProcessHandler = null;
        this.myActions = AnAction.EMPTY_ARRAY;
    }

    public DefaultExecutionResult(@Nullable ExecutionConsole console, @NotNull ProcessHandler processHandler) {
        this(console, processHandler, AnAction.EMPTY_ARRAY);
    }

    public DefaultExecutionResult(ExecutionConsole console, @NotNull ProcessHandler processHandler, AnAction ... actions) {
        this.myConsole = console;
        this.myProcessHandler = processHandler;
        this.myActions = actions;
    }

    @Override
    public ExecutionConsole getExecutionConsole() {
        return this.myConsole;
    }

    @Override
    public AnAction[] getActions() {
        return this.myActions;
    }

    public void setActions(AnAction ... actions) {
        this.myActions = actions;
    }

    @NotNull
    public AnAction[] getRestartActions() {
        return this.myRestartActions;
    }

    public void setRestartActions(AnAction ... restartActions) {
        this.myRestartActions = restartActions != null ? restartActions : AnAction.EMPTY_ARRAY;
    }

    public void addStopAction(AnAction action) {
        this.myStopActions.add(action);
    }

    @NotNull
    public AnAction[] getAdditionalStopActions() {
        return this.myStopActions.toArray(new AnAction[this.myStopActions.size()]);
    }

    @Override
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }
}

